/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.views;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.IProjectSettingsChangeListener;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.views.IPerforceView;
import com.perforce.team.ui.views.IPerforceViewControl;
import com.perforce.team.ui.views.Messages;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractPerforceViewControl
implements IPerforceViewControl,
IProjectSettingsChangeListener,
ISelectionListener {
    private IPerforceView view;
    Link showMore;
    protected IP4Connection p4Connection;
    protected Composite displayArea;
    private Label connectionLabel;
    private Composite stackComposite;
    private StackLayout stackLayout;
    private Label noConnectionSelected;
    protected boolean layout = false;
    int retrieveCount = 0;
    protected static final ISchedulingRule RULE = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }
    };
    protected IP4Listener p4Listener = new IP4Listener(){

        public void resoureChanged(P4Event event) {
            final IP4Connection current = AbstractPerforceViewControl.this.p4Connection;
            if (current != null && P4Event.EventType.REMOVED == event.getType()) {
                IP4Connection[] iP4ConnectionArray = event.getConnections();
                int n = iP4ConnectionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Connection connection = iP4ConnectionArray[n2];
                    if (current.equals(connection)) {
                        UIJob invalidateConnection = new UIJob(Messages.PerforceProjectView_UpdateViewForRemovedConnection){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if ((this).AbstractPerforceViewControl.this.p4Connection == current) {
                                    AbstractPerforceViewControl.this.showNoConnection();
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        invalidateConnection.setSystem(true);
                        invalidateConnection.schedule();
                        break;
                    }
                    ++n2;
                }
            }
        }

        public String getName() {
            return AbstractPerforceViewControl.class.getSimpleName();
        }
    };

    protected abstract String getSelectedName();

    protected abstract void createControl(Composite var1);

    protected IPerforceView getView() {
        return this.view;
    }

    public AbstractPerforceViewControl(IPerforceView view) {
        this.view = view;
    }

    protected void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
        IWorkbenchPartSite site = this.getView().getSite();
        if (site != null) {
            site.registerContextMenu(menuManager, selectionProvider);
            site.setSelectionProvider(selectionProvider);
        }
    }

    protected IActionBars getActionBars() {
        IWorkbenchPartSite site = this.getView().getSite();
        if (site instanceof IViewSite) {
            return ((IViewSite)site).getActionBars();
        }
        return null;
    }

    @Override
    public IP4Connection getConnection() {
        return this.p4Connection;
    }

    @Override
    public Composite createViewControl(Composite parent) {
        this.stackComposite = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.stackComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.noConnectionSelected = new Label(this.stackComposite, 64);
        this.noConnectionSelected.setText(MessageFormat.format(Messages.PerforceProjectView_SelectAResource, this.getSelectedName()));
        this.stackLayout.topControl = this.noConnectionSelected;
        this.displayArea = new Composite(this.stackComposite, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        daLayout.horizontalSpacing = 0;
        daLayout.verticalSpacing = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.connectionLabel = new Label(this.displayArea, 64);
        this.connectionLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.updateConnectionLabel();
        this.createControl(this.displayArea);
        this.setInitialConnection(this.getView().getConnection());
        this.layout = true;
        return this.stackComposite;
    }

    void updateMoreButton(boolean layout) {
        if (this.showMore != null && !this.showMore.isDisposed()) {
            int max = this.getMaxChangelists();
            if (max == -1) {
                this.showMore.setText(Messages.SubmittedChangelistTable_ShowMore);
                this.showMore.setEnabled(false);
            } else {
                this.showMore.setText(MessageFormat.format(Messages.SubmittedChangelistTable_ShowNumMore, max));
                this.showMore.setEnabled(true);
            }
            if (layout) {
                this.showMore.getParent().layout(new Control[]{this.showMore});
            }
        }
    }

    public void showMore() {
        if (this.retrieveCount != -1) {
            this.retrieveCount += this.getMaxChangelists();
        }
    }

    public static IPreferenceStore getPreferenceStore() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore();
    }

    public void clearFetchCount() {
        this.retrieveCount = this.getMaxChangelists();
        this.updateMoreButton(false);
    }

    public int getFetchCount() {
        return this.retrieveCount;
    }

    int getMaxChangelists() {
        return AbstractPerforceViewControl.getPreferenceStore().getInt("pref_retrieve_num_changes");
    }

    public void refreshRetrieveCount() {
        this.retrieveCount = this.getMaxChangelists();
    }

    private void setInitialConnection(IP4Connection connection) {
        if (connection != null) {
            this.selectionChanged(null, (ISelection)new StructuredSelection((Object)connection));
        }
    }

    protected void updateConnectionLabel() {
        IP4Connection connection = this.p4Connection;
        if (connection != null) {
            String name = connection.getName();
            if (name == null) {
                name = "";
            }
            this.connectionLabel.setText(MessageFormat.format(Messages.PerforceProjectView_Connection, name));
        }
    }

    protected final void removeProjectListeners() {
        IWorkbenchPartSite site = this.getView().getSite();
        if (site != null) {
            site.getPage().removeSelectionListener((ISelectionListener)this);
        }
        PerforceProviderPlugin.removeProjectSettingsChangeListener((IProjectSettingsChangeListener)this);
        P4ConnectionManager.getManager().removeListener(this.p4Listener);
    }

    protected final void addProjectListeners() {
        PerforceProviderPlugin.addProjectSettingsChangeListener((IProjectSettingsChangeListener)this);
        P4ConnectionManager.getManager().addListener(this.p4Listener);
        IWorkbenchPartSite site = this.getView().getSite();
        if (site != null) {
            site.getPage().addSelectionListener((ISelectionListener)this);
        }
    }

    public void projectSettingsChanged(IProject project, ConnectionParameters params) {
        this.changeConnection(P4ConnectionManager.getManager().getConnection(project));
    }

    private void connectionSelected(final IP4Connection connection) {
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                AbstractPerforceViewControl.this.changeConnection(connection);
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                AbstractPerforceViewControl.this.connectionSelected(AbstractPerforceViewControl.getConnection(selection));
            }
        }, (ISchedulingRule)RULE);
    }

    public void changeConnection(ISelection selection) {
        this.changeConnection(AbstractPerforceViewControl.getConnection(selection));
    }

    public static IP4Connection getConnection(ISelection selection) {
        IP4Connection connection = null;
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            IResource resource = AbstractPerforceViewControl.getResource(element);
            if (resource != null) {
                IP4Resource p4Resource;
                IProject project = resource.getProject();
                if (project != null) {
                    connection = P4ConnectionManager.getManager().getConnection(project);
                }
                if (connection == null && (p4Resource = P4ConnectionManager.getManager().getResource(resource)) != null) {
                    connection = p4Resource.getConnection();
                }
            } else if (element instanceof IP4Connection) {
                connection = (IP4Connection)element;
                if (!connection.isOffline() && !connection.isConnected()) {
                    connection.connect();
                }
            } else if (element instanceof IP4Resource) {
                connection = ((IP4Resource)element).getConnection();
            }
        }
        return connection;
    }

    protected IP4Resource getP4Resource(Object element) {
        IP4Resource p4Resource = null;
        IResource resource = AbstractPerforceViewControl.getResource(element);
        if (resource != null) {
            p4Resource = P4ConnectionManager.getManager().getResource(resource);
        }
        return p4Resource;
    }

    public static IResource getResource(Object obj) {
        if (obj instanceof IResource) {
            return (IResource)obj;
        }
        if (obj instanceof IAdaptable) {
            return (IResource)((IAdaptable)obj).getAdapter(IResource.class);
        }
        return null;
    }

    protected void changeConnection(final IP4Connection newConnection) {
        if (!(newConnection == null || this.showingConnection() && newConnection == this.p4Connection)) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractPerforceViewControl.this.p4Connection = newConnection;
                    AbstractPerforceViewControl.this.setConnection(AbstractPerforceViewControl.this.p4Connection);
                }
            });
        }
    }

    protected boolean showingConnection() {
        return this.stackLayout != null && this.stackLayout.topControl != this.noConnectionSelected;
    }

    protected void showDisplayArea(boolean layout) {
        this.stackLayout.topControl = this.displayArea;
        if (layout) {
            this.stackComposite.layout(true, true);
        }
    }

    protected void showDisplayArea() {
        this.showDisplayArea(this.layout);
    }

    protected void showNoConnection(boolean layout) {
        this.stackLayout.topControl = this.noConnectionSelected;
        if (layout) {
            this.stackComposite.layout(true, true);
        }
    }

    protected void showNoConnection() {
        this.showNoConnection(this.layout);
    }

    protected void setConnection(IP4Connection connection) {
        this.clearFetchCount();
        this.updateConnectionLabel();
        this.setViewerInput(connection);
    }

    protected void setViewerInput(IP4Connection connection) {
    }

    protected boolean connectionOK(IP4Connection connection) {
        return connection != null && !connection.isOffline() && !connection.isDisposed();
    }
}

