/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.timelapse;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.timelapse.Messages;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class TimeLapseInput
extends PlatformObject
implements IEditorInput {
    private IP4File file;
    private boolean enableBranchHistory = true;
    private boolean useChangelists = true;

    public TimeLapseInput(IP4File file) {
        this.file = file;
    }

    public TimeLapseInput(IP4File file, boolean enableBranchHistory, boolean useChangelistKeys) {
        this.file = file;
        this.enableBranchHistory = enableBranchHistory;
        this.useChangelists = useChangelistKeys;
    }

    public IP4File getFile() {
        return this.file;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return PerforceUIPlugin.getDescriptor("normal/time_lapse.png");
    }

    public String getName() {
        return this.file.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return MessageFormat.format(Messages.TimeLapseInput_TimelapseOf, this.file.getRemotePath());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IFile.class) {
            return this.file.getLocalFileForLocation();
        }
        if (adapter == IP4Resource.class || adapter == IP4File.class) {
            return this.file;
        }
        if (adapter == IP4Connection.class) {
            return this.file.getConnection();
        }
        return super.getAdapter(adapter);
    }

    public boolean enableBranchHistoy() {
        return this.enableBranchHistory;
    }

    public boolean useChangelistKeys() {
        return this.useChangelists;
    }
}

