/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.synchronize;

import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.synchronize.PerforceSyncInfo;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.p4java.actions.ResolveAction;
import com.perforce.team.ui.synchronize.PerforceSyncModelOperation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ResolveModelOperation
extends PerforceSyncModelOperation {
    private ResolveFilesAutoOptions options = null;
    private boolean showDialog = true;

    public ResolveModelOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        P4Collection collection = this.createCollection();
        SyncInfo[] syncInfoArray = this.getSyncInfoSet().getSyncInfos();
        int n = syncInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo element = syncInfoArray[n2];
            if (element instanceof PerforceSyncInfo) {
                collection.add((IP4Resource)((PerforceSyncInfo)element).getP4File());
            }
            ++n2;
        }
        final ResolveAction action = new ResolveAction();
        action.setCollection(collection);
        final ArrayList events = new ArrayList();
        IP4Listener listener = new IP4Listener(){

            public void resoureChanged(P4Event event) {
                if (P4Event.EventType.RESOLVED == event.getType()) {
                    IP4File[] iP4FileArray = event.getFiles();
                    int n = iP4FileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4File file = iP4FileArray[n2];
                        events.add(file);
                        ++n2;
                    }
                }
            }

            public String getName() {
                return ((Object)((Object)ResolveModelOperation.this)).getClass().getSimpleName();
            }
        };
        collection.sync(monitor);
        P4ConnectionManager.getManager().addListener(listener);
        if (this.showDialog) {
            P4UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    action.runAction();
                }
            });
        } else if (this.options != null) {
            action.resolve(this.options);
        }
        P4ConnectionManager.getManager().removeListener(listener);
        if (!events.isEmpty()) {
            SyncInfo[] syncInfoArray2 = this.getSyncInfoSet().getSyncInfos();
            int n3 = syncInfoArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IP4File file;
                SyncInfo element = syncInfoArray2[n4];
                if (element instanceof PerforceSyncInfo && (file = ((PerforceSyncInfo)element).getP4File()) != null && events.contains(file)) {
                    try {
                        element.getLocal().refreshLocal(1, null);
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                    this.updateSyncState(element.getLocal());
                }
                ++n4;
            }
        }
    }

    public ResolveFilesAutoOptions getOptions() {
        return this.options;
    }

    public void setOptions(ResolveFilesAutoOptions options) {
        this.options = options;
    }

    public boolean isShowDialog() {
        return this.showDialog;
    }

    public void setShowDialog(boolean showDialog) {
        this.showDialog = showDialog;
    }
}

