/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.action;

import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.swarmreview.action.PendingReviewAction;
import com.perforce.team.ui.swarmreview.restapi.Result;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

public class OpenPendingChangeOnlineAction
extends PendingReviewAction {
    @Override
    protected void runAction() {
        try {
            final IP4PendingChangelist pendingChangeList = (IP4PendingChangelist)this.getSelection().toList().get(0);
            final IP4Resource[] selectedItems = pendingChangeList.getAllMembers();
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    if (selectedItems.length > 0) {
                        OpenPendingChangeOnlineAction.this.showOpenedBrowser(pendingChangeList);
                    } else {
                        MessageDialog.openConfirm(null, (String)"No Changes", (String)"No Changes Found");
                    }
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showOpenedBrowser(final IP4PendingChangelist pendingChangeList) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                OpenPendingChangeOnlineAction.this.initSwarmController(pendingChangeList, true);
                try {
                    OpenPendingChangeOnlineAction.this.controller.openSwarmChangeOnline();
                }
                catch (Exception e) {
                    MessageDialog.openError(null, (String)"Open Swarm", (String)"Unable to open");
                }
            }
        });
    }

    @Override
    public boolean isEnabledEx() {
        boolean enabled = false;
        IP4PendingChangelist pendingChangeList = this.getCurrentSelection();
        if (pendingChangeList != null) {
            this.initSwarmController(pendingChangeList, false);
            Result<Boolean> result = this.controller.isOpenChange(pendingChangeList);
            enabled = result.isSuccessful();
            if (!result.isSuccessful()) {
                result.isReportInSilence();
            }
        }
        return enabled;
    }
}

