/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.action;

import com.perforce.p4java.server.IServer;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.swarmreview.action.SubmittedReviewAction;
import com.perforce.team.ui.swarmreview.dialogs.NewSubmittedReviewDialog;
import com.perforce.team.ui.swarmreview.restapi.Result;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

public class NewSubmittedReviewAction
extends SubmittedReviewAction {
    @Override
    protected void runAction() {
        try {
            final IP4SubmittedChangelist pendingChangeList = (IP4SubmittedChangelist)this.getSelection().toList().get(0);
            final IP4Resource[] selectedItems = pendingChangeList.getFiles();
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    if (selectedItems.length > 0) {
                        IServer iserver = selectedItems[0].getServer();
                        NewSubmittedReviewAction.this.showNoOpenedFilesDialog(pendingChangeList, selectedItems, iserver);
                    } else {
                        MessageDialog.openConfirm(null, (String)"No Changes", (String)"No Changes Found");
                    }
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showNoOpenedFilesDialog(final IP4SubmittedChangelist pendingChangeList, IP4Resource[] selectedItems, IServer iserver) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                NewSubmittedReviewAction.this.initSwarmController(pendingChangeList, true);
                NewSubmittedReviewDialog srd = new NewSubmittedReviewDialog(NewSubmittedReviewAction.this.getShell());
                srd.setController(NewSubmittedReviewAction.this.controller);
                srd.open();
            }
        });
    }

    @Override
    public boolean isEnabledEx() {
        boolean enabled = false;
        IP4SubmittedChangelist pendingChangeList = this.getCurrentSelection();
        if (pendingChangeList != null) {
            this.initSwarmController(pendingChangeList, false);
            Result<Boolean> result = this.controller.isChangeListCandidateForNewReview(pendingChangeList);
            enabled = result.isSuccessful();
            if (!result.isSuccessful()) {
                result.isReportInSilence();
            }
        }
        return enabled;
    }
}

