/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview.action;

import com.perforce.p4java.server.IServer;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.swarmreview.action.PendingReviewAction;
import com.perforce.team.ui.swarmreview.dialogs.NewPendingReviewDialog;
import com.perforce.team.ui.swarmreview.restapi.Result;
import org.eclipse.core.runtime.IProgressMonitor;

public class NewPendingReviewAction
extends PendingReviewAction {
    @Override
    protected void runAction() {
        try {
            final IP4PendingChangelist pendingChangeList = (IP4PendingChangelist)this.getSelection().toList().get(0);
            final IP4Resource[] selectedItems = pendingChangeList.getAllMembers();
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    NewPendingReviewAction.this.showNoOpenedFilesDialog(pendingChangeList, selectedItems, null);
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showNoOpenedFilesDialog(final IP4PendingChangelist pendingChangeList, IP4Resource[] selectedItems, IServer iserver) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                NewPendingReviewAction.this.initSwarmController(pendingChangeList, true);
                NewPendingReviewDialog srd = new NewPendingReviewDialog(NewPendingReviewAction.this.getShell());
                srd.setController(NewPendingReviewAction.this.controller);
                if (srd.open() != 0) {
                    return;
                }
                if (srd.isRevertChecked()) {
                    NewPendingReviewAction.this.revertFiles(srd.getCheckedFiles(), srd.isRemoveChecked());
                }
            }
        });
    }

    @Override
    public boolean isEnabledEx() {
        boolean enabled = false;
        IP4PendingChangelist pendingChangeList = this.getCurrentSelection();
        if (pendingChangeList != null) {
            this.initSwarmController(pendingChangeList, false);
            Result<Boolean> result = this.controller.isChangeListCandidateForNewReview(pendingChangeList);
            enabled = result.isSuccessful();
            if (!result.isSuccessful()) {
                result.isReportInSilence();
            }
        }
        return enabled;
    }
}

