/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.swarmreview;

import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.P4DefaultChangelist;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4PendingChangelist;
import com.perforce.team.core.p4java.P4ShelvedChangelist;
import com.perforce.team.ui.swarmreview.PendingChangeListData;
import com.perforce.team.ui.swarmreview.PendingReviewModel;
import com.perforce.team.ui.swarmreview.ReviewManager;
import com.perforce.team.ui.swarmreview.restapi.Result;
import java.util.ArrayList;
import java.util.List;

public class PendingReviewManager
extends ReviewManager<IP4PendingChangelist> {
    private static ReviewManager<IP4PendingChangelist> managerInstance = new PendingReviewManager();

    public static ReviewManager<IP4PendingChangelist> getInstance(IP4Connection connection) {
        PendingReviewManager.managerInstance.connection = connection;
        return managerInstance;
    }

    @Override
    public void init(IP4PendingChangelist pendingChangeList, boolean clearState) {
        if (this.model == null) {
            this.model = PendingReviewModel.getNewInstance();
        }
        if (clearState) {
            this.clearState();
        }
        this.initSelectedChangelist(pendingChangeList);
        if (this.connection == null && pendingChangeList != null) {
            this.connection = pendingChangeList.getConnection();
        }
        this.ignoreSSL = this.connection.getParameters().isIgnoreSSLValidation();
    }

    @Override
    public boolean updateChangelist() {
        boolean changeListModified = false;
        try {
            IChangelist cl = this.getConnection().getServer().getChangelist(((IP4PendingChangelist)this.model.getPendingChangeList()).getId());
            P4PendingChangelist pendingCl = new P4PendingChangelist(this.getConnection(), cl, true);
            boolean bl = changeListModified = cl.getFiles(true).size() != this.getFilesInSelectedChangelist().length;
            if (changeListModified) {
                List files = cl.getFiles(true);
                for (IFileSpec fs : files) {
                    P4File p4File = new P4File(fs, (IP4Container)this.getConnection());
                    pendingCl.addFile((IP4File)p4File);
                }
                this.populateCurrentChangelistItems((IP4PendingChangelist)pendingCl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return changeListModified;
    }

    @Override
    void populateCurrentChangelistItems(IP4PendingChangelist pendingChangeList) {
        ArrayList<IP4Resource> ip4Changes = new ArrayList<IP4Resource>();
        if (pendingChangeList != null) {
            int n;
            if (this.model.getPendingChangeList() != null && ((IP4PendingChangelist)this.model.getPendingChangeList()).getId() == pendingChangeList.getId()) {
                return;
            }
            IP4Resource[] changeListData = pendingChangeList.getAllMembers();
            if (changeListData != null) {
                IP4Resource[] iP4ResourceArray = changeListData;
                n = changeListData.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource file = iP4ResourceArray[n2];
                    if (file instanceof IP4File) {
                        ip4Changes.add(file);
                    }
                    if (file instanceof P4ShelvedChangelist) {
                        P4ShelvedChangelist shelvedChange = (P4ShelvedChangelist)file;
                        IP4Resource[] shelvedFiles = shelvedChange.getFiles();
                        ArrayList shelvedFilesList = new ArrayList();
                        if (shelvedFiles.length == 0) {
                            shelvedFiles = shelvedFilesList.toArray(shelvedFiles);
                        }
                        this.model.setShelvedChangeList((IP4ShelvedChangelist)shelvedChange);
                        this.model.setFilesInSelectedShelf(shelvedFiles);
                    }
                    ++n2;
                }
            }
            if (this.model.getFilesInSelectedShelf() != null && this.model.getFilesInSelectedShelf().length > 0) {
                IP4Resource[] shelvedFiles;
                IP4Resource[] iP4ResourceArray = shelvedFiles = this.model.getFilesInSelectedShelf();
                int n3 = shelvedFiles.length;
                n = 0;
                while (n < n3) {
                    IP4Resource res = iP4ResourceArray[n];
                    boolean cfr_ignored_0 = res instanceof IP4ShelveFile;
                    ++n;
                }
            }
            IP4Resource[] ip4Array = ip4Changes.toArray(new IP4Resource[ip4Changes.size()]);
            this.model.setFilesInSelectedChangelist(ip4Array);
            this.model.setPendingChangeList(pendingChangeList);
        }
    }

    public void initSelectedChangelist(IP4PendingChangelist pendingChangeList) {
        if (pendingChangeList != null) {
            IP4PendingChangelist[] newcl = new IP4PendingChangelist[]{pendingChangeList};
            this.populateChangelistData(newcl);
            this.model.addP4Changelist(pendingChangeList);
            PendingChangeListData pclData = this.model.getChangeListDataById(pendingChangeList);
            if (pclData != null) {
                this.model.setFilesInSelectedChangelist(pclData.getFilesInPendingChangelist());
                this.model.setPendingChangeList(pclData.getPendingChangeList());
                this.model.setFilesInSelectedShelf(pclData.getFilesShelved());
                this.model.setShelvedChangeList(pclData.getShelvedChangeList());
            }
        }
    }

    public void populateChangelistData(IP4PendingChangelist[] pendingChangeListItems) {
        IP4PendingChangelist[] iP4PendingChangelistArray = pendingChangeListItems;
        int n = pendingChangeListItems.length;
        int n2 = 0;
        while (n2 < n) {
            IP4PendingChangelist cl = iP4PendingChangelistArray[n2];
            this.populateCurrentChangelistItems(cl);
            PendingChangeListData clData = new PendingChangeListData((IP4PendingChangelist)this.model.getPendingChangeList(), cl.getShelvedChanges(), this.model.getFilesInSelectedChangelist(), this.model.getFilesInSelectedShelf());
            this.model.addChangeListData(clData);
            ++n2;
        }
    }

    @Override
    public IP4PendingChangelist getP4ChangelistById(IP4PendingChangelist cl) {
        IP4PendingChangelist selectedCl = (IP4PendingChangelist)this.model.getP4ChangeListIdToChangeListMap().get(String.valueOf(cl.getId()) + "@" + cl.getClientName());
        if (selectedCl == null) {
            IP4PendingChangelist[] newcl = new IP4PendingChangelist[]{cl};
            this.populateChangelistData(newcl);
            this.model.addP4Changelist(cl);
        }
        return (IP4PendingChangelist)this.model.getP4ChangeListIdToChangeListMap().get(String.valueOf(cl.getId()) + "@" + cl.getClientName());
    }

    public void createCache(IP4PendingChangelist[] lists) {
        super.createCache((IP4Changelist[])lists);
        this.populateChangelistData(lists);
    }

    @Override
    public Result<Boolean> isChangeListCandidateForNewReview(IP4PendingChangelist currentSelection) {
        IP4PendingChangelist pendingChangeList = currentSelection;
        Result<Boolean> canContinue = this.canContinue();
        if (!canContinue.isSuccessful()) {
            return new Result<Boolean>(canContinue, canContinue.isSuccessful());
        }
        if (pendingChangeList == null) {
            return new Result<Boolean>(false).withNoSuccess("New Review not supported, Empty changelist", Boolean.FALSE);
        }
        int validContentCount = this.getFilesInSelectedChangelist().length;
        int validShelfCount = this.getFilesInSelectedShelf().length;
        if (pendingChangeList instanceof P4DefaultChangelist && validContentCount > 0) {
            return new Result<Boolean>(true).withSuccess("New Review supported", Boolean.TRUE);
        }
        boolean hasReview = this.isChangelistInReview(pendingChangeList);
        if (hasReview) {
            return new Result<Boolean>(false).withNoSuccess("New Review not supported. Already in review", Boolean.FALSE);
        }
        if (validContentCount == 0) {
            // empty if block
        }
        boolean finalResult = !hasReview;
        return new Result<Boolean>(finalResult).withValues(finalResult, false, "New Review support status: " + finalResult, false, finalResult);
    }

    @Override
    public Result<Boolean> isChangeListCandidateForUpdateReview(IP4PendingChangelist currentSelection) {
        int shelvedFiles;
        IP4PendingChangelist pendingChangeList = currentSelection;
        Result<Boolean> canContinue = this.canContinue();
        if (!canContinue.isSuccessful()) {
            return new Result<Boolean>(canContinue, canContinue.isSuccessful());
        }
        if (pendingChangeList == null) {
            return new Result<Boolean>(false).withNoSuccess("Update not supported, Empty changelist", Boolean.FALSE);
        }
        int validContentCount = this.getPendingFilesCount();
        int n = shelvedFiles = this.getFilesInSelectedShelf() == null ? 0 : this.getFilesInSelectedShelf().length;
        if (pendingChangeList instanceof P4DefaultChangelist && validContentCount > 0) {
            return new Result<Boolean>(true).withSuccess("Update supported", Boolean.TRUE);
        }
        boolean hasReview = this.isChangelistInReview(pendingChangeList);
        if (hasReview && validContentCount > 0) {
            return new Result<Boolean>(true).withSuccess("Update supported", Boolean.TRUE);
        }
        boolean finalResult = !hasReview;
        return new Result<Boolean>(finalResult).withValues(finalResult, false, "Update Review support status: " + finalResult, false, finalResult);
    }

    @Override
    public Result<Boolean> isOpenChange(IP4PendingChangelist currentSelection) {
        Result<Boolean> canContinue = this.canContinue();
        if (!canContinue.isSuccessful()) {
            return new Result<Boolean>(canContinue, canContinue.isSuccessful());
        }
        if (currentSelection instanceof P4DefaultChangelist) {
            return new Result<Boolean>(false).withNoSuccess("Not supported, Default changelist", Boolean.FALSE);
        }
        return new Result<Boolean>(true).withSuccess("Open change supported", Boolean.TRUE);
    }

    @Override
    public Result<Boolean> isOpenReview(IP4PendingChangelist currentSelection) {
        IP4PendingChangelist pendingChangeList = currentSelection;
        Result<Boolean> canContinue = this.canContinue();
        if (!canContinue.isSuccessful()) {
            return new Result<Boolean>(canContinue, canContinue.isSuccessful());
        }
        if (pendingChangeList instanceof P4DefaultChangelist) {
            return new Result<Boolean>(false).withNoSuccess("Not supported, Default changelist", Boolean.FALSE);
        }
        boolean finalResult = this.isChangelistInReview(pendingChangeList);
        return new Result<Boolean>(finalResult).withValues(finalResult, false, "Open Review support status: " + finalResult, false, finalResult);
    }
}

