/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.changelists.DescriptionViewer;
import com.perforce.team.ui.dialogs.FileListViewer;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.shelve.Messages;
import java.text.MessageFormat;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SubmitShelveDialog
extends P4StatusDialog {
    private Label countLabel;
    private FileListViewer viewer;
    private DescriptionViewer descriptionViewer;
    private IP4ShelvedChangelist changelist;

    public SubmitShelveDialog(Shell parent, String title, IP4ShelvedChangelist changelist) {
        super(parent, title);
        this.changelist = changelist;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayout cLayout = new GridLayout(2, false);
        cLayout.marginHeight = 0;
        cLayout.marginWidth = 0;
        composite.setLayout((Layout)cLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.countLabel = new Label(composite, 16384);
        GridData clData = new GridData(4, 4, true, false);
        clData.verticalIndent = 5;
        clData.horizontalSpan = 2;
        this.countLabel.setLayoutData((Object)clData);
        this.viewer = new FileListViewer(composite, this.changelist.members(), this.changelist.members(), false);
        ((GridData)this.viewer.getTable().getLayoutData()).horizontalSpan = 2;
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.ConfirmShelveDialog_Description);
        this.descriptionViewer = new DescriptionViewer((IP4Resource)this.changelist.getConnection());
        this.descriptionViewer.createControl(composite, this.changelist.getDescription());
        StyledText styledText = this.descriptionViewer.getViewer().getTextWidget();
        ((GridData)styledText.getLayoutData()).heightHint = P4UIUtils.computePixelHeight(styledText.getFont(), 5);
        styledText.setSelection(0, 0);
        this.descriptionViewer.setFocus();
        this.viewer.getTable().setEnabled(false);
        styledText.setEnabled(false);
        this.updateCount();
        return dialogArea;
    }

    private void updateCount() {
        int count = this.viewer.getCheckedElements().length;
        int max = this.viewer.getTable().getItemCount();
        this.countLabel.setText(MessageFormat.format(Messages.ConfirmShelveDialog_FilesSelected, count, max));
    }
}

