/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4Storage;
import com.perforce.team.ui.diff.DiffContentProvider;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.StructuredViewer;

public class ShelvedFileContentProvider
extends DiffContentProvider {
    public ShelvedFileContentProvider(StructuredViewer viewer) {
        super(viewer);
    }

    public ShelvedFileContentProvider(StructuredViewer viewer, boolean async) {
        super(viewer, async);
    }

    public ShelvedFileContentProvider(StructuredViewer viewer, Object context) {
        super(viewer, context);
    }

    public ShelvedFileContentProvider(StructuredViewer viewer, boolean async, Object context) {
        super(viewer, async, context);
    }

    @Override
    public IStorage getLeftStorage(IP4Resource resource, final IP4File file) {
        final int change = file.getChangelistId();
        if (change > 0) {
            return new P4Storage(){

                public InputStream getContents() throws CoreException {
                    return file.getRemoteContents("@=" + change);
                }
            };
        }
        return null;
    }

    @Override
    public IStorage getRightStorage(IP4Resource resource, final IP4File file) {
        final int change = file.getHaveRevision();
        if (change > 0) {
            return new P4Storage(){

                public InputStream getContents() throws CoreException {
                    return file.getRemoteContents("#" + change);
                }
            };
        }
        return null;
    }

    @Override
    public boolean canDiff(IP4Resource resource) {
        if (resource instanceof IP4ShelveFile) {
            IP4ShelveFile file = (IP4ShelveFile)resource;
            return file.getChangelist().getId() > 0 && P4File.isActionEdit((FileAction)file.getFile().getAction());
        }
        return false;
    }
}

