/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.shelve.FileShelfWidget;
import com.perforce.team.ui.shelve.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DiffShelveDialog
extends P4StatusDialog {
    private FileShelfWidget widget;
    private IP4File file;
    private IP4ShelveFile[] shelves;
    private IP4ShelveFile selected;
    private boolean revert = false;

    public DiffShelveDialog(Shell parent, IP4File file, IP4ShelveFile[] shelves) {
        super(parent);
        this.setTitle(MessageFormat.format(Messages.DiffShelveDialog_CompareWithShelvedVersion, file.getName()));
        this.setModalResizeStyle();
        this.file = file;
        this.shelves = shelves;
    }

    @Override
    protected String getSectionName() {
        return "FILE_SHELF_WIDGET";
    }

    public boolean revert() {
        return this.revert;
    }

    public IP4ShelveFile getSelected() {
        return this.selected;
    }

    protected void okPressed() {
        this.selected = this.widget.getSelectedFile();
        this.revert = this.widget.isRevert();
        super.okPressed();
    }

    private void validate() {
        if (this.widget.getViewer().getSelection().isEmpty()) {
            this.setErrorMessage(Messages.DiffShelveDialog_MustSelectShelvedFile);
        } else {
            this.setErrorMessage(null);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.widget = new FileShelfWidget(this.shelves, this.file, MessageFormat.format(Messages.DiffShelveDialog_ComparingFile, this.file.getRemotePath()));
        this.widget.createControl(c, false);
        this.widget.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DiffShelveDialog.this.okPressed();
            }
        });
        this.widget.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiffShelveDialog.this.validate();
            }
        });
        this.validate();
        return c;
    }
}

