/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.server;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.impl.generic.client.ClientOptions;
import com.perforce.p4java.impl.generic.client.ClientSubmitOptions;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.option.server.GetStreamOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.IErrorDisplay;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.server.Messages;
import com.perforce.team.ui.streams.StreamsSuggestProvider;
import com.perforce.team.ui.streams.SuggestBox;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ClientWidget
implements IErrorProvider {
    private Composite displayArea;
    private Label workspaceLabel;
    private Text workspaceText;
    private Label updateLabel;
    private Text updateText;
    private Label accessLabel;
    private Text accessText;
    private Label ownerLabel;
    private Text ownerText;
    private Label hostLabel;
    private Text hostText;
    private Label submitLabel;
    private Combo submitCombo;
    private Label lineLabel;
    private Combo lineCombo;
    private Label descriptionLabel;
    private Text descriptionText;
    private Label streamLabel;
    private SuggestBox streamCombo;
    private Label rootLabel;
    private Text rootText;
    private Label altRootsLabel;
    private Text altRootsText;
    private Label optionsLabel;
    private Composite optionsArea;
    private Button allwriteButton;
    private Button clobberButton;
    private Button compressButton;
    private Button lockedButton;
    private Button modtimeButton;
    private Button rmdirButton;
    private Label viewLabel;
    private Text viewText;
    private Composite serverIdArea;
    private Button restrictToServerId;
    private Text serverIdText;
    private Text streamAtChangeText;
    private IP4Connection connection;
    private IClient spec;
    private IClient currentSpec;
    private StreamsSuggestProvider provider;
    private IErrorDisplay errorDisplay;
    private boolean clientNameEditable;

    public ClientWidget(IP4Connection connection, IClient spec) {
        this(connection, spec, false);
    }

    public ClientWidget(IP4Connection connection, IClient spec, boolean newClient) {
        this.connection = connection;
        this.spec = spec;
        this.provider = new StreamsSuggestProvider(connection);
        this.clientNameEditable = newClient;
    }

    private void fillSubmitCombo(IClient spec) {
        this.submitCombo.add(Messages.ClientWidget_NoneSelected);
        this.submitCombo.add("submitunchanged");
        this.submitCombo.add("submitunchanged+reopen");
        this.submitCombo.add("revertunchanged");
        this.submitCombo.add("revertunchanged+reopen");
        this.submitCombo.add("leaveunchanged");
        this.submitCombo.add("leaveunchanged+reopen");
        IClientSummary.IClientSubmitOptions options = spec.getSubmitOptions();
        if (options != null) {
            if (options.isSubmitunchanged()) {
                this.submitCombo.select(1);
            } else if (options.isSubmitunchangedReopen()) {
                this.submitCombo.select(2);
            } else if (options.isRevertunchanged()) {
                this.submitCombo.select(3);
            } else if (options.isRevertunchangedReopen()) {
                this.submitCombo.select(4);
            } else if (options.isLeaveunchanged()) {
                this.submitCombo.select(5);
            } else if (options.isLeaveunchangedReopen()) {
                this.submitCombo.select(6);
            } else {
                this.submitCombo.select(0);
            }
        } else {
            this.submitCombo.select(0);
        }
    }

    private void fillLineEndCombo(IClient spec) {
        this.lineCombo.add(Messages.ClientWidget_NoneSelected);
        this.lineCombo.add("local");
        this.lineCombo.add("unix");
        this.lineCombo.add("mac");
        this.lineCombo.add("win");
        this.lineCombo.add("share");
        IClientSummary.ClientLineEnd endings = spec.getLineEnd();
        if (IClientSummary.ClientLineEnd.LOCAL == endings) {
            this.lineCombo.select(1);
        } else if (IClientSummary.ClientLineEnd.UNIX == endings) {
            this.lineCombo.select(2);
        } else if (IClientSummary.ClientLineEnd.MAC == endings) {
            this.lineCombo.select(3);
        } else if (IClientSummary.ClientLineEnd.WIN == endings) {
            this.lineCombo.select(4);
        } else if (IClientSummary.ClientLineEnd.SHARE == endings) {
            this.lineCombo.select(5);
        } else {
            this.lineCombo.select(0);
        }
    }

    private String getSelectedStream() {
        Object stream;
        SuggestBox.SelectionModel model;
        if (this.streamCombo != null && (model = (SuggestBox.SelectionModel)this.streamCombo.getModel().getValue()) != null && (stream = model.getSelection()) instanceof IStreamSummary) {
            return ((IStreamSummary)stream).getStream();
        }
        return null;
    }

    private IClientSummary.ClientLineEnd getSelectedLineEnding() {
        switch (this.lineCombo.getSelectionIndex()) {
            case 1: {
                return IClientSummary.ClientLineEnd.LOCAL;
            }
            case 2: {
                return IClientSummary.ClientLineEnd.UNIX;
            }
            case 3: {
                return IClientSummary.ClientLineEnd.MAC;
            }
            case 4: {
                return IClientSummary.ClientLineEnd.WIN;
            }
            case 5: {
                return IClientSummary.ClientLineEnd.SHARE;
            }
        }
        return null;
    }

    private IClientSummary.IClientSubmitOptions getSelectedSubmitOptions() {
        ClientSubmitOptions options = null;
        int index = this.submitCombo.getSelectionIndex();
        if (index > 0) {
            options = new ClientSubmitOptions();
            switch (index) {
                case 1: {
                    options.setSubmitunchanged(true);
                    break;
                }
                case 2: {
                    options.setSubmitunchangedReopen(true);
                    break;
                }
                case 3: {
                    options.setRevertunchanged(true);
                    break;
                }
                case 4: {
                    options.setRevertunchangedReopen(true);
                    break;
                }
                case 5: {
                    options.setLeaveunchanged(true);
                    break;
                }
                case 6: {
                    options.setLeaveunchangedReopen(true);
                }
            }
        }
        return options;
    }

    private IClientSummary.IClientOptions getSelectedOptions() {
        ClientOptions options = new ClientOptions();
        options.setAllWrite(this.allwriteButton.getSelection());
        options.setClobber(this.clobberButton.getSelection());
        options.setCompress(this.compressButton.getSelection());
        options.setLocked(this.lockedButton.getSelection());
        options.setModtime(this.modtimeButton.getSelection());
        options.setRmdir(this.rmdirButton.getSelection());
        return options;
    }

    private ClientView getClientView() {
        ClientView view = new ClientView();
        StringTokenizer tokenizer = new StringTokenizer(this.viewText.getText(), "\r\n");
        int count = 0;
        while (tokenizer.hasMoreElements()) {
            view.addEntry((IMapEntry)new ClientView.ClientViewMapping(count, tokenizer.nextToken()));
            ++count;
        }
        return view;
    }

    private void createTopControls(Composite parent, IClient spec) {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yy hh:mm aaa");
        GridData textData = new GridData(4, 4, true, false);
        this.workspaceLabel = new Label(parent, 16384);
        this.workspaceLabel.setText(Messages.ClientWidget_Workspace);
        this.workspaceText = new Text(parent, 0x804 | (this.clientNameEditable ? 0 : 8));
        this.workspaceText.setLayoutData((Object)textData);
        if (spec.getName() != null) {
            this.workspaceText.setText(spec.getName());
        }
        this.hostLabel = new Label(parent, 16384);
        this.hostLabel.setText(Messages.ClientWidget_Host);
        this.hostText = new Text(parent, 2052);
        this.hostText.setLayoutData((Object)textData);
        if (spec.getHostName() != null) {
            this.hostText.setText(spec.getHostName());
        }
        this.updateLabel = new Label(parent, 16384);
        this.updateLabel.setText(Messages.ClientWidget_Update);
        this.updateText = new Text(parent, 2060);
        this.updateText.setLayoutData((Object)textData);
        if (spec.getUpdated() != null) {
            this.updateText.setText(format.format(spec.getUpdated()));
        }
        this.submitLabel = new Label(parent, 16384);
        this.submitLabel.setText(Messages.ClientWidget_SubmitOptions);
        this.submitCombo = new Combo(parent, 12);
        this.submitCombo.setLayoutData((Object)textData);
        this.fillSubmitCombo(spec);
        this.accessLabel = new Label(parent, 16384);
        this.accessLabel.setText(Messages.ClientWidget_Access);
        this.accessText = new Text(parent, 2060);
        this.accessText.setLayoutData((Object)textData);
        if (spec.getAccessed() != null) {
            this.accessText.setText(format.format(spec.getAccessed()));
        }
        this.lineLabel = new Label(parent, 16384);
        this.lineLabel.setText(Messages.ClientWidget_LineEnd);
        this.lineCombo = new Combo(parent, 12);
        this.lineCombo.setLayoutData((Object)textData);
        this.fillLineEndCombo(spec);
        this.ownerLabel = new Label(parent, 16384);
        this.ownerLabel.setText(Messages.ClientWidget_Owner);
        this.ownerText = new Text(parent, 2052);
        if (spec.getOwnerName() != null) {
            this.ownerText.setText(spec.getOwnerName());
        }
        this.ownerText.setLayoutData((Object)textData);
        if (this.connection.getIntVersion() >= 20062) {
            new Label(parent, 16384);
            new Label(parent, 16384);
        } else {
            GridData hiddenData = new GridData(4, 4, true, false);
            hiddenData.exclude = true;
            this.submitCombo.setLayoutData((Object)hiddenData);
            this.submitLabel.setLayoutData((Object)hiddenData);
        }
    }

    private void createBottomControls(Composite parent, IClient spec) {
        boolean enableView = true;
        GridData labelData = new GridData(4, 128, false, false);
        GridData largeTextData = new GridData(4, 4, true, true);
        largeTextData.heightHint = 100;
        largeTextData.horizontalSpan = 3;
        this.descriptionLabel = new Label(parent, 16384);
        this.descriptionLabel.setText(Messages.ClientWidget_Description);
        this.descriptionLabel.setLayoutData((Object)labelData);
        this.descriptionText = new Text(parent, 2050);
        this.descriptionText.setLayoutData((Object)largeTextData);
        if (spec.getDescription() != null) {
            this.descriptionText.setText(spec.getDescription());
        }
        if (this.connection.getIntVersion() >= 20111) {
            this.streamLabel = new Label(parent, 16384);
            this.streamLabel.setText(Messages.ClientWidget_Stream);
            this.streamCombo = new SuggestBox(parent, 0, this.provider);
            this.streamCombo.setLayoutData(GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).create());
            String current = spec.getStream();
            if (!StringUtils.isEmpty((CharSequence)current)) {
                IP4Stream stream = this.connection.getStream(current);
                enableView = stream == null;
                this.streamCombo.getModel().setValue((Object)new SuggestBox.SelectionModel(null, stream == null ? null : stream.getStreamSummary()));
                this.streamCombo.refresh();
            }
            if (this.connection.getServer().getServerVersionNumber() >= 20121) {
                Label streamAtChangeLabel = new Label(parent, 16384);
                streamAtChangeLabel.setText(Messages.ClientWidget_StreamAtChange);
                this.streamAtChangeText = new Text(parent, 2048);
                if (-1 != spec.getStreamAtChange()) {
                    this.streamAtChangeText.setText(String.valueOf(spec.getStreamAtChange()));
                }
                SWTUtils.decorate((Control)this.streamAtChangeText, 16512);
                SWTUtils.updateDecoration((Control)this.streamAtChangeText, ValidationStatus.info((String)Messages.ClientWidget_InputChangeListNumberMsg));
                GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)this.streamAtChangeText);
            }
        }
        this.rootLabel = new Label(parent, 16384);
        this.rootLabel.setText(Messages.ClientWidget_Root);
        this.rootText = new Text(parent, 2052);
        this.rootText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).create());
        if (spec.getRoot() != null) {
            this.rootText.setText(spec.getRoot());
        }
        this.altRootsLabel = new Label(parent, 16384);
        this.altRootsLabel.setLayoutData((Object)labelData);
        this.altRootsLabel.setText(Messages.ClientWidget_AltRoots);
        this.altRootsText = new Text(parent, 2818);
        GridData artData = new GridData(4, 4, true, false);
        artData.horizontalSpan = 3;
        artData.heightHint = P4UIUtils.computePixelHeight(this.altRootsText.getFont(), 3);
        this.altRootsText.setLayoutData((Object)artData);
        if (spec.getAlternateRoots() != null) {
            StringBuilder roots = new StringBuilder();
            for (String alt : spec.getAlternateRoots()) {
                if (alt == null) continue;
                roots.append(alt);
                roots.append('\n');
            }
            this.altRootsText.setText(roots.toString());
        }
        this.optionsLabel = new Label(parent, 16384);
        this.optionsLabel.setText(Messages.ClientWidget_Options);
        this.optionsArea = new Composite(parent, 2052);
        this.optionsArea.setLayout((Layout)new GridLayout(6, false));
        if (spec.getOptions() != null) {
            this.allwriteButton = new Button(this.optionsArea, 32);
            this.allwriteButton.setText("allwrite");
            this.allwriteButton.setSelection(spec.getOptions().isAllWrite());
            this.clobberButton = new Button(this.optionsArea, 32);
            this.clobberButton.setText("clobber");
            this.clobberButton.setSelection(spec.getOptions().isClobber());
            this.compressButton = new Button(this.optionsArea, 32);
            this.compressButton.setText("compress");
            this.compressButton.setSelection(spec.getOptions().isCompress());
            this.lockedButton = new Button(this.optionsArea, 32);
            this.lockedButton.setText("locked");
            this.lockedButton.setSelection(spec.getOptions().isLocked());
            this.modtimeButton = new Button(this.optionsArea, 32);
            this.modtimeButton.setText("modtime");
            this.modtimeButton.setSelection(spec.getOptions().isModtime());
            this.rmdirButton = new Button(this.optionsArea, 32);
            this.rmdirButton.setText("rmdir");
            this.rmdirButton.setSelection(spec.getOptions().isRmdir());
        }
        GridData fixedTextData = new GridData(4, 4, true, false);
        fixedTextData.horizontalSpan = 3;
        fixedTextData.widthHint = this.optionsArea.computeSize((int)-1, (int)-1).x;
        this.optionsArea.setLayoutData((Object)fixedTextData);
        if (this.connection.getServer().getServerVersionNumber() >= 20121) {
            new Label(parent, 16384);
            this.serverIdArea = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            this.serverIdArea.setLayout((Layout)layout);
            this.serverIdArea.setLayoutData((Object)fixedTextData);
            this.restrictToServerId = new Button(this.serverIdArea, 32);
            this.restrictToServerId.setText(Messages.ClientWidget_RestrictToServerId);
            this.restrictToServerId.setSelection(StringUtils.isNotEmpty((CharSequence)spec.getServerId()));
            this.restrictToServerId.setLayoutData((Object)GridDataFactory.swtDefaults().align(16384, 128).create());
            this.serverIdText = new Text(this.serverIdArea, 2052);
            this.serverIdText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 128).grab(true, false).indent(5, -1).create());
            SWTUtils.decorate((Control)this.serverIdText, 16512);
            SWTUtils.updateDecoration((Control)this.serverIdText, ValidationStatus.ok());
            if (StringUtils.isNotEmpty((CharSequence)spec.getServerId())) {
                this.restrictToServerId.setSelection(true);
                this.serverIdText.setText(spec.getServerId());
            } else {
                this.restrictToServerId.setSelection(false);
                this.serverIdText.setText(this.lookupServerId());
                this.serverIdText.setEnabled(false);
            }
            this.restrictToServerId.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClientWidget.this.serverIdText.setEnabled(ClientWidget.this.restrictToServerId.getSelection());
                    ClientWidget.this.serverIdText.setText(ClientWidget.this.serverIdText.getText());
                }
            });
        }
        this.viewLabel = new Label(parent, 16384);
        this.viewLabel.setText(Messages.ClientWidget_View);
        this.viewLabel.setLayoutData((Object)labelData);
        this.viewText = new Text(parent, 2818);
        this.viewText.setLayoutData((Object)largeTextData);
        this.viewText.setEditable(enableView);
        if (this.connection.getIntVersion() >= 20111 && !StringUtils.isEmpty((CharSequence)spec.getStream())) {
            this.updateClientView(spec.getStream());
        } else if (spec.getClientView() != null) {
            String mappings = this.getViewMapping(spec.getClientView().getEntryList());
            this.viewText.setText(mappings);
        }
    }

    private String getViewMapping(List<? extends IMapEntry> list) {
        StringBuilder builder = new StringBuilder();
        if (list != null) {
            Collections.sort(list, new Comparator<IMapEntry>(){

                @Override
                public int compare(IMapEntry o1, IMapEntry o2) {
                    return o1.getOrder() - o2.getOrder();
                }
            });
            for (IMapEntry iMapEntry : list) {
                builder.append(iMapEntry.toString(" ", true));
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    private void createClientControls(Composite parent, IClient spec) {
        this.createTopControls(parent, spec);
        this.createBottomControls(parent, spec);
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(4, false);
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createClientControls(this.displayArea, this.spec);
        this.descriptionText.forceFocus();
        this.addListeners();
    }

    public void updateCurrentSpec() {
        Client latestSpec = new Client();
        latestSpec.setName(this.workspaceText.getText());
        latestSpec.setDescription(this.descriptionText.getText());
        latestSpec.setHostName(this.hostText.getText());
        latestSpec.setRoot(this.rootText.getText());
        String[] altRoots = null;
        String altRootText = this.altRootsText.getText().trim();
        if (!StringUtils.isEmpty((CharSequence)altRootText)) {
            altRoots = altRootText.split("\n");
            P4UIUtils.addIndentToAltRoots(altRoots);
            latestSpec.setAlternateRoots(new Vector<String>(Arrays.asList(altRoots)));
        } else {
            latestSpec.setAlternateRoots(new ArrayList());
        }
        latestSpec.setOwnerName(this.ownerText.getText());
        latestSpec.setLineEnd(this.getSelectedLineEnding());
        latestSpec.setSubmitOptions(this.getSelectedSubmitOptions());
        latestSpec.setOptions(this.getSelectedOptions());
        if (this.connection.getIntVersion() >= 20111 && !StringUtils.isEmpty((CharSequence)this.getSelectedStream())) {
            latestSpec.setStream(this.getSelectedStream());
        } else {
            latestSpec.setClientView(this.getClientView());
        }
        if (this.connection.getServer().getServerVersionNumber() >= 20121) {
            if (!StringUtils.isEmpty((CharSequence)this.streamAtChangeText.getText().trim())) {
                latestSpec.setStreamAtChange(Integer.parseInt(this.streamAtChangeText.getText().trim()));
            }
            latestSpec.setServerId(this.getServerIdText());
        }
        this.currentSpec = latestSpec;
    }

    public IClient getCurrentSpec() {
        return this.currentSpec;
    }

    public String getWorkspaceText() {
        return this.workspaceText.getText();
    }

    public String getDescriptionText() {
        return this.descriptionText.getText();
    }

    public String getHostText() {
        return this.hostText.getText();
    }

    public String getRootText() {
        return this.rootText.getText();
    }

    public String getOwnerText() {
        return this.ownerText.getText();
    }

    public String getLineEndingText() {
        return this.lineCombo.getText();
    }

    public String getSubmitOptionText() {
        return this.submitCombo.getText();
    }

    public String getViewText() {
        return this.viewText.getText();
    }

    public String getServerIdText() {
        if (this.connection.getServer().getServerVersionNumber() >= 20121) {
            if (this.restrictToServerId == null) {
                return null;
            }
            if (!this.restrictToServerId.getSelection()) {
                return null;
            }
            return this.serverIdText.getText();
        }
        return null;
    }

    private String lookupServerId() {
        String serverId = null;
        try {
            serverId = this.spec.getServer().getServerInfo().getServerId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serverId == null) {
            serverId = "";
        }
        return serverId;
    }

    private void addListeners() {
        if (this.connection.getIntVersion() >= 20111) {
            this.streamCombo.getModel().addValueChangeListener(new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    SuggestBox.SelectionModel model = (SuggestBox.SelectionModel)ClientWidget.this.streamCombo.getModel().getValue();
                    if (model.getSelection() != null) {
                        ClientWidget.this.viewText.setText(Messages.ClientWidget_Refreshing);
                        ClientWidget.this.viewText.setEditable(false);
                        if (model.getSelection() instanceof IStreamSummary) {
                            String sum = ((IStreamSummary)model.getSelection()).getStream();
                            ClientWidget.this.updateClientView(sum);
                        }
                    } else {
                        ClientWidget.this.viewText.setText("");
                        ClientWidget.this.viewText.setEditable(true);
                    }
                }
            });
        }
        if (this.connection.getServer().getServerVersionNumber() >= 20121) {
            this.streamAtChangeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ClientWidget.this.validate();
                }
            });
            if (this.serverIdText != null) {
                this.serverIdText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        ClientWidget.this.validate();
                    }
                });
            }
        }
    }

    protected void updateClientView(final String sum) {
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.ClientWidget_LoadingStreamView;
            }

            public void run(IProgressMonitor monitor) {
                try {
                    IOptionsServer server = (IOptionsServer)ClientWidget.this.connection.getServer();
                    GetStreamOptions opt = new GetStreamOptions(true);
                    opt.setOptions(new String[]{"-o"});
                    IStream stream = server.getStream(sum, opt);
                    ViewMap view = stream.getClientView();
                    if (view != null) {
                        final String mappings = ClientWidget.this.getViewMapping(view.getEntryList());
                        PerforceUIPlugin.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ClientWidget.this.viewText.setText(mappings);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ClientWidget.this.viewText.setText("");
                }
            }
        });
    }

    @Override
    public void validate() {
        if (this.connection.getServer().getServerVersionNumber() >= 20121) {
            String name;
            String error;
            IStatus status = ValidationStatus.ok();
            if (this.serverIdText.getEnabled() && (error = P4UIUtils.validateName(name = this.serverIdText.getText(), "Server")) != null) {
                SWTUtils.updateDecoration((Control)this.serverIdText, ValidationStatus.error((String)error));
                this.errorDisplay.setErrorMessage(Messages.ClientWidget_IllegalServerName, this);
                return;
            }
            SWTUtils.updateDecoration((Control)this.serverIdText, status);
            try {
                int num;
                if (!StringUtils.isEmpty((CharSequence)this.streamAtChangeText.getText().trim()) && (num = Integer.parseInt(this.streamAtChangeText.getText().trim())) < 0) {
                    this.errorDisplay.setErrorMessage(Messages.ClientWidget_AtChangeMustBeInteger, this);
                    return;
                }
            }
            catch (Throwable t) {
                this.errorDisplay.setErrorMessage(Messages.ClientWidget_AtChangeMustBeInteger, this);
                return;
            }
        }
        this.errorDisplay.setErrorMessage(null, this);
    }

    @Override
    public void setErrorDisplay(IErrorDisplay display) {
        this.errorDisplay = display;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }
}

