/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.refactor;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.p4java.actions.DeleteAction;
import com.perforce.team.ui.refactor.IDeleteManager;
import com.perforce.team.ui.refactor.RefactorManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class DeleteManager
extends RefactorManager
implements IDeleteManager {
    private void delete(IP4Resource resource, IProgressMonitor monitor) {
        P4Collection collection = new P4Collection(new IP4Resource[]{resource});
        collection.revert();
        DeleteAction action = new DeleteAction();
        action.setCollection(collection);
        action.setMonitor(monitor);
        action.setAsync(false);
        action.run(null);
        if (action.wasDialogCancelled()) {
            throw new OperationCanceledException("Changelist selection dialog was cancelled.");
        }
    }

    private boolean isIgnored(IResource resource) {
        return PerforceProviderPlugin.isIgnoredHint((IResource)resource);
    }

    private boolean isLinked(IResource resource) {
        return resource.isLinked();
    }

    private boolean checkLink(IResource resource) {
        return this.isEnabled("PREF_DELETE_LINKED_RESOURCES") || !this.isLinked(resource);
    }

    @Override
    public boolean delete(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        IP4Resource resource;
        boolean standard = true;
        if (this.isEnabled() && !this.isIgnored((IResource)file) && this.checkLink((IResource)file) && (resource = P4ConnectionManager.getManager().getResource((IResource)file)) instanceof IP4File) {
            this.delete(resource, monitor);
            if (!this.exists((IResource)file)) {
                tree.deletedFile(file);
                standard = false;
            }
        }
        if (standard) {
            tree.standardDeleteFile(file, updateFlags, monitor);
        }
        return false;
    }

    @Override
    public boolean delete(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        IP4Resource resource;
        boolean standard = true;
        if (this.isEnabled() && !this.isIgnored((IResource)folder) && this.checkLink((IResource)folder) && (resource = P4ConnectionManager.getManager().getResource((IResource)folder)) instanceof IP4Container) {
            this.delete(resource, monitor);
            if (!this.exists((IResource)folder)) {
                tree.deletedFolder(folder);
                standard = false;
            }
        }
        if (standard) {
            tree.standardDeleteFolder(folder, updateFlags, monitor);
        }
        return true;
    }

    @Override
    public boolean delete(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        IP4Resource resource;
        boolean standard = true;
        if (this.isEnabled("pref_delete_project_files") && (resource = P4ConnectionManager.getManager().getResource((IResource)project)) instanceof IP4Container) {
            this.delete(resource, monitor);
            if (!this.exists((IResource)project)) {
                tree.deletedProject(project);
                standard = false;
            }
        }
        if (standard) {
            tree.standardDeleteProject(project, updateFlags, monitor);
        }
        return false;
    }
}

