/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.preferences;

import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.PerforceDialog;
import com.perforce.team.ui.preferences.Messages;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AdvancedPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.perforce.team.ui.preferences.AdvancedPreferencePage";
    private Composite displayArea;
    private Label propertiesLabel;
    private TableViewer propertiesTable;
    private Button addButton;
    private Button removeButton;
    private Image addImage;
    private Image removeImage;
    private Map<String, String> properties;

    public AdvancedPreferencePage() {
        this.setDescription(Messages.AdvancedPreferencePage_AdvancedP4EclipseSettings);
    }

    protected Control createContents(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createPropertyTable(this.displayArea);
        return this.displayArea;
    }

    public void dispose() {
        super.dispose();
        this.addImage.dispose();
        this.removeImage.dispose();
    }

    private void createPropertyTable(Composite parent) {
        Composite tableArea = new Composite(parent, 0);
        tableArea.setLayout((Layout)new GridLayout(2, false));
        tableArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.propertiesLabel = new Label(tableArea, 16384);
        GridData plData = new GridData(4, 4, true, false);
        plData.verticalIndent = 10;
        plData.horizontalSpan = 2;
        this.propertiesLabel.setLayoutData((Object)plData);
        this.propertiesLabel.setText(Messages.AdvancedPreferencePage_CustonP4JavaProperties);
        this.propertiesTable = new TableViewer(tableArea, 68354);
        TableLayout ptLayout = new TableLayout();
        ptLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        ptLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        TableColumn nameColumn = new TableColumn(this.propertiesTable.getTable(), 0);
        nameColumn.setText(Messages.AdvancedPreferencePage_Name);
        TableColumn valueColumn = new TableColumn(this.propertiesTable.getTable(), 0);
        valueColumn.setText(Messages.AdvancedPreferencePage_Value);
        this.propertiesTable.getTable().setLayout((Layout)ptLayout);
        this.propertiesTable.getTable().setHeaderVisible(true);
        this.propertiesTable.getTable().setLinesVisible(true);
        this.propertiesTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.propertiesTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                if (columnIndex == 0) {
                    value = element.toString();
                } else if (columnIndex == 1) {
                    value = (String)AdvancedPreferencePage.this.properties.get(element);
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.propertiesTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.propertiesTable.setSorter(new ViewerSorter());
        Composite buttons = new Composite(tableArea, 0);
        buttons.setLayout((Layout)new GridLayout(1, true));
        buttons.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addButton = new Button(buttons, 8);
        this.addImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/add.png").createImage();
        this.addButton.setToolTipText(Messages.AdvancedPreferencePage_AddPropertyTooltip);
        this.addButton.setImage(this.addImage);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PairDialog dialog = new PairDialog(AdvancedPreferencePage.this.addButton.getShell());
                if (dialog.open() == 0) {
                    String name = dialog.getName();
                    String value = dialog.getValue();
                    AdvancedPreferencePage.this.properties.put(name, value);
                    AdvancedPreferencePage.this.propertiesTable.refresh();
                }
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/delete.png").createImage();
        this.removeButton.setImage(this.removeImage);
        this.removeButton.setToolTipText(Messages.AdvancedPreferencePage_RemovePropertyTooltip);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)AdvancedPreferencePage.this.propertiesTable.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object key = objectArray[n2];
                    AdvancedPreferencePage.this.properties.remove(key);
                    ++n2;
                }
                AdvancedPreferencePage.this.propertiesTable.refresh();
            }
        });
        this.loadProperties();
    }

    private void loadProperties() {
        String[] pairs;
        this.properties = new HashMap<String, String>();
        String current = this.getPreferenceStore().getString("com.perforce.team.ui.preferences.CUSTOM_P4JAVA_PROPERTIES");
        String[] stringArray = pairs = current.split("###");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] sections = pair.split("===");
            if (sections.length == 2) {
                this.properties.put(sections[0], sections[1]);
            }
            ++n2;
        }
        this.propertiesTable.setInput(this.properties.keySet());
    }

    private void saveProperties() {
        StringBuilder pairs = new StringBuilder();
        for (String key : this.properties.keySet()) {
            String value = this.properties.get(key);
            pairs.append(key);
            pairs.append("===");
            pairs.append(value);
            pairs.append("###");
        }
        this.getPreferenceStore().setValue("com.perforce.team.ui.preferences.CUSTOM_P4JAVA_PROPERTIES", pairs.toString());
    }

    protected void performDefaults() {
        this.properties.clear();
        this.propertiesTable.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        this.saveProperties();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PerforceUIPlugin.getPlugin().getPreferenceStore());
    }

    private static class PairDialog
    extends PerforceDialog {
        private Text nameText;
        private Text valueText;
        private String name = null;
        private String value = null;

        public PairDialog(Shell parent) {
            super(parent, Messages.AdvancedPreferencePage_AddProperty);
        }

        protected Control createDialogArea(Composite parent) {
            Composite c = (Composite)super.createDialogArea(parent);
            c.setLayout((Layout)new GridLayout(2, false));
            this.createLabel(c, Messages.AdvancedPreferencePage_NameLabel);
            this.nameText = this.createTextField(c);
            this.createLabel(c, Messages.AdvancedPreferencePage_ValueLabel);
            this.valueText = this.createTextField(c);
            return c;
        }

        protected void okPressed() {
            this.name = this.nameText.getText().trim();
            this.value = this.valueText.getText().trim();
            super.okPressed();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

