/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4v;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4v.Messages;
import com.perforce.team.ui.p4v.P4VRunner;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StreamsRunner
extends P4VRunner {
    private IP4Connection connection = null;
    private String exec;
    private boolean useP4vc = false;

    public StreamsRunner(IP4Connection connection) {
        this.connection = connection;
    }

    @Override
    protected void addCommandOpt(List<String> arguments) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.useP4vc) {
            args.add("streamgraph");
        } else {
            args.add("streamsGraph");
            args.add("flow");
        }
        int i = 0;
        while (i < args.size()) {
            arguments.add((String)args.get(i));
            ++i;
        }
    }

    @Override
    protected IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    protected void applicationFinished(int exitCode) {
        if (exitCode != 0) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    P4ConnectionManager.getManager().openInformation(P4UIUtils.getShell(), Messages.StreamsRunner_ErrorTitle, Messages.StreamsRunner_ErrorMessage);
                }
            });
        }
    }

    @Override
    protected boolean loadFiles() {
        return true;
    }

    @Override
    protected String getApplicationName() {
        return Messages.StreamsRunner_Title;
    }

    @Override
    protected String getTaskName() {
        return Messages.StreamsRunner_Title;
    }

    @Override
    protected String getExecutable() {
        if (this.exec == null) {
            String p4vPath;
            block6: {
                p4vPath = this.getPreferenceStore().getString(this.getPreference());
                try {
                    File[] children;
                    File parent = new File(p4vPath).getParentFile();
                    if (parent == null || !parent.exists() || (children = parent.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.getName().contains("p4vc");
                        }
                    })) == null) break block6;
                    File[] fileArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File c = fileArray[n2];
                        if (c.canExecute()) {
                            this.exec = c.getAbsolutePath();
                            this.useP4vc = true;
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
            }
            if (this.exec == null) {
                this.exec = p4vPath;
            }
        }
        return this.exec;
    }

    @Override
    protected List<String> getCommand() {
        return Collections.emptyList();
    }
}

