/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4v;

import com.perforce.p4java.CharsetDefs;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.ConnectionWizard;
import com.perforce.team.ui.connection.ConnectionWizardDialog;
import com.perforce.team.ui.p4merge.ApplicationRunner;
import com.perforce.team.ui.p4v.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public class P4SandboxConfigRunner
extends ApplicationRunner {
    private IP4Connection connection = null;

    public P4SandboxConfigRunner(IP4Connection connection) {
        this.connection = connection;
    }

    @Override
    protected IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    protected ProcessBuilder getBuilder() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.getPreferenceValue());
        arguments.add("-p");
        arguments.add(this.getConnection().getParameters().getPort());
        arguments.add("-u");
        arguments.add(this.getConnection().getParameters().getUser());
        arguments.add("-c");
        arguments.add(this.getConnection().getParameters().getClient());
        arguments.add("-C");
        String charset = this.getConnection().getParameters().getCharset();
        if (charset == null) {
            charset = "none";
        }
        arguments.add(charset);
        if (this.shouldConvertExec()) {
            this.convertExec(arguments);
        }
        return new ProcessBuilder(arguments);
    }

    @Override
    protected String getPreference() {
        return "com.perforce.team.ui.preferences.P4MFA_APP_PATH";
    }

    @Override
    protected boolean loadFiles() {
        return true;
    }

    @Override
    protected void applicationFinished(int exitCode) {
        if (exitCode != 0) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    P4ConnectionManager.getManager().openInformation(P4UIUtils.getShell(), Messages.P4SandboxConfigRunner_ErrorTitle, Messages.P4SandboxConfigRunner_ErrorMessage);
                }
            });
        } else {
            InputStream stdout = this.getProcess().getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stdout, CharsetDefs.DEFAULT));
            StringBuffer sb = new StringBuffer();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException line) {
                // empty catch block
            }
            String[] parts = sb.toString().trim().split(" ");
            HashMap<String, String> config = new HashMap<String, String>();
            int i = 0;
            while (i + 1 < parts.length) {
                config.put(parts[i], parts[i + 1]);
                i += 2;
            }
            final String port = (String)config.get("-p");
            final String user = (String)config.get("-u");
            final String client = (String)config.get("-c");
            final String charset = (String)config.get("-C");
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    ConnectionWizardDialog dialog = new ConnectionWizardDialog(P4UIUtils.getShell(), new ConnectionWizard(port, user, client, charset));
                    dialog.open();
                }
            });
        }
    }

    @Override
    protected String getApplicationName() {
        return Messages.P4SandboxConfigRunner_Title;
    }
}

