/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4merge;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.p4merge.ApplicationRunner;
import java.io.File;
import java.util.ArrayList;

public class DiffRunner
extends ApplicationRunner {
    private IP4Connection connection;
    private boolean loadLeft = false;
    private boolean loadRight = false;
    private String leftLabel;
    private String rightLabel;
    private String leftPath;
    private String rightPath;

    public DiffRunner(IP4Connection connection, boolean loadLeft, boolean loadRight, String leftLabel, String leftPath, String rightLabel, String rightPath) {
        this.connection = connection;
        this.loadLeft = loadLeft;
        this.loadRight = loadRight;
        this.leftLabel = leftLabel;
        this.leftPath = leftPath;
        this.rightLabel = rightLabel;
        this.rightPath = rightPath;
    }

    @Override
    protected IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    protected ProcessBuilder getBuilder() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.getPreferenceValue());
        arguments.add("-C");
        arguments.add("none");
        arguments.add("-nl");
        arguments.add(this.leftLabel);
        arguments.add("-nr");
        arguments.add(this.rightLabel);
        arguments.add(this.leftPath);
        arguments.add(this.rightPath);
        return new ProcessBuilder(arguments);
    }

    @Override
    protected String getPreference() {
        return "com.perforce.team.ui.preferences.P4MERGE_PATH";
    }

    @Override
    protected boolean loadFiles() {
        boolean success = true;
        if (this.loadLeft) {
            File leftFile = this.connection.printToTempFile(this.leftPath);
            if (leftFile != null) {
                this.leftPath = leftFile.getAbsolutePath();
            } else {
                success = false;
            }
        }
        if (this.loadRight) {
            File rightFile = this.connection.printToTempFile(this.rightPath);
            if (rightFile != null) {
                this.rightPath = rightFile.getAbsolutePath();
            } else {
                success = false;
            }
        }
        return success;
    }

    @Override
    protected String getApplicationName() {
        return "P4Merge";
    }

    @Override
    protected void applicationFinished(int exitCode) {
    }
}

