/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.p4java.dialogs.BrowseStreamDialog;
import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.streams.StreamComboViewer;
import com.perforce.team.ui.streams.StreamUtil;
import com.perforce.team.ui.streams.StreamsSuggestProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SourceTargetStreamWidget
extends Composite
implements IntegrateToStreamDialog.ISourceTargetWidget<IStreamSummary>,
IntegrateToStreamDialog.ILongtimeTask {
    private IStreamSummary sourcePath = null;
    private IStreamSummary targetPath = null;
    private IP4Resource resource;
    private boolean showAll = false;
    private Button browseAllBtn;
    private StreamComboViewer sourceCombo;
    private StreamComboViewer targetCombo;
    protected List<IStreamSummary> preferredStreams = new ArrayList<IStreamSummary>();
    protected IStream targetStream = null;

    public SourceTargetStreamWidget(Composite parent, int style, String title, IP4Resource resource) {
        super(parent, style);
        this.resource = resource;
        this.createControl(this, title);
        this.addListeners();
        this.updateFromModel();
    }

    protected StreamsSuggestProvider createSourceProvider(IP4Resource resource) {
        return new StreamsSuggestProvider(resource.getConnection());
    }

    protected void createControl(Composite parent, String title) {
        parent.setLayout((Layout)new FillLayout());
        Group filePathArea = new Group(parent, 0);
        filePathArea.setText(title);
        GridLayout fpaLayout = new GridLayout(3, false);
        filePathArea.setLayout((Layout)fpaLayout);
        Label sourceLabel = new Label((Composite)filePathArea, 16384);
        sourceLabel.setText(Messages.IntegrateDialog_SourceLabel);
        this.sourceCombo = new StreamComboViewer((Composite)filePathArea, 0);
        this.sourceCombo.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.createBrowseForStreamButton((Composite)filePathArea, (Object)this.sourceCombo);
        Label targetLabel = new Label((Composite)filePathArea, 16384);
        targetLabel.setText(Messages.IntegrateDialog_TargetLabel);
        this.targetCombo = new StreamComboViewer((Composite)filePathArea, 2052);
        this.targetCombo.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void addListeners() {
    }

    public void updateFromModel() {
    }

    private void updateToModel() {
        this.sourcePath = this.sourceCombo.getSelectedObject();
        this.targetPath = this.targetCombo.getSelectedObject();
    }

    @Override
    public IStatus validate() {
        if (this.sourceCombo.getSelectedObject() == null) {
            return ValidationStatus.error((String)Messages.IntegrateDialog_MustEnterSourcePath);
        }
        if (this.targetCombo.getSelectedObject() == null) {
            return ValidationStatus.error((String)Messages.IntegrateDialog_MustEnterTargetPath);
        }
        this.updateToModel();
        return ValidationStatus.ok();
    }

    @Override
    public IStreamSummary getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public IStreamSummary getTargetPath() {
        return this.targetPath;
    }

    @Override
    public Composite getControl() {
        return this;
    }

    @Override
    public boolean isShowAllSource() {
        return this.showAll;
    }

    private void createBrowseForStreamButton(Composite parent, Object update) {
        this.browseAllBtn = new Button(parent, 8);
        this.browseAllBtn.setText(Messages.SourceTargetStreamWidget_Browse);
        this.browseAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseStreamDialog dlg = new BrowseStreamDialog(SourceTargetStreamWidget.this.getShell(), SourceTargetStreamWidget.this.resource.getConnection(), Messages.SourceTargetStreamWidget_InfornationText);
                if (dlg.open() == 0) {
                    ArrayList<IStreamSummary> newList = new ArrayList<IStreamSummary>();
                    IStreamSummary sum = dlg.getSelectedStream();
                    if (sum != null) {
                        newList.addAll(SourceTargetStreamWidget.this.preferredStreams);
                        IStreamSummary s = StreamUtil.matchStream(sum.getStream(), SourceTargetStreamWidget.this.preferredStreams);
                        if (s != null) {
                            newList.remove(s);
                        }
                        newList.add(0, sum);
                    }
                    SourceTargetStreamWidget.this.sourceCombo.setInput(newList.toArray());
                    SourceTargetStreamWidget.this.sourceCombo.select(dlg.getSelectedStream());
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.browseAllBtn.setEnabled(enabled);
        this.sourceCombo.getControl().setEnabled(enabled);
    }

    @Override
    public Runnable getNonUIJob() {
        return new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    @Override
    public Runnable getUIJob() {
        return new Runnable(){

            @Override
            public void run() {
                if (!SourceTargetStreamWidget.this.sourceCombo.getControl().isDisposed()) {
                    SourceTargetStreamWidget.this.sourceCombo.setInput(SourceTargetStreamWidget.this.preferredStreams.toArray());
                }
                if (!SourceTargetStreamWidget.this.targetCombo.getControl().isDisposed()) {
                    SourceTargetStreamWidget.this.targetCombo.setInput(new IStreamSummary[]{SourceTargetStreamWidget.this.targetStream});
                    SourceTargetStreamWidget.this.targetCombo.select((IStreamSummary)SourceTargetStreamWidget.this.targetStream);
                }
            }
        };
    }
}

