/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.changelists.PendingCombo;
import com.perforce.team.ui.dialogs.FileListViewer;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenDialog
extends P4StatusDialog {
    private FileListViewer viewer;
    private IP4Connection connection;
    private IP4Resource[] allFiles;
    private IP4Resource[] selectedFiles;
    private boolean useSelected = false;
    private String comboTitle;
    private PendingCombo changeCombo;
    private Label countLabel;
    private String defaultDescription = null;
    private int selectedId;

    public OpenDialog(Shell parent, IP4Resource[] resources, IP4Connection connection, int selectedId, String dialogTitle, String comboTitle) {
        this(parent, resources, connection, selectedId, dialogTitle, comboTitle, null);
    }

    public OpenDialog(Shell parent, IP4Resource[] resources, IP4Connection connection, int selectedId, String dialogTitle, String comboTitle, String description) {
        this(parent, resources, connection, dialogTitle, comboTitle, description);
        this.selectedId = selectedId;
    }

    public OpenDialog(Shell parent, IP4Resource[] resources, IP4Connection connection, String dialogTitle, String comboTitle) {
        this(parent, resources, connection, dialogTitle, comboTitle, null);
    }

    public OpenDialog(Shell parent, IP4Resource[] resources, IP4Connection connection, String dialogTitle, String comboTitle, String description) {
        super(parent, dialogTitle);
        this.connection = connection;
        this.allFiles = resources;
        this.comboTitle = comboTitle;
        this.defaultDescription = description;
        this.setModalResizeStyle();
    }

    public IP4Resource[] getSelectedFiles() {
        return this.selectedFiles;
    }

    public int getSelectedChangeId() {
        return this.changeCombo.getSelected();
    }

    public String getDescription() {
        return this.changeCombo.getDescription();
    }

    public boolean useSelected() {
        return this.useSelected;
    }

    private void updateCount() {
        int count = this.viewer.getCheckedElements().length;
        int max = this.viewer.getTable().getItemCount();
        this.countLabel.setText(MessageFormat.format(Messages.OpenDialog_FilesNumSelected, count, max));
        if (count == 0) {
            this.setErrorMessage(Messages.OpenDialog_MustSelectAtLeastOneFile, null);
        } else {
            this.setErrorMessage(null);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        GridLayout cLayout = new GridLayout(2, false);
        cLayout.marginHeight = 0;
        cLayout.marginWidth = 0;
        composite.setLayout((Layout)cLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.changeCombo = this.createChangeCombo(composite);
        this.countLabel = new Label(composite, 16384);
        GridData clData = new GridData(4, 4, true, false);
        clData.verticalIndent = 5;
        clData.horizontalSpan = 2;
        this.countLabel.setLayoutData((Object)clData);
        this.viewer = new FileListViewer(composite, this.allFiles, this.allFiles, false);
        ((GridData)this.viewer.getTable().getLayoutData()).horizontalSpan = 2;
        final Button useSelectedButton = new Button(composite, 32);
        useSelectedButton.setText(Messages.OpenDialog_UseSelectedChangelist);
        GridData usbData = new GridData(4, 4, true, false);
        usbData.horizontalSpan = 2;
        useSelectedButton.setLayoutData((Object)usbData);
        useSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenDialog.this.useSelected = useSelectedButton.getSelection();
            }
        });
        this.updateCount();
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                OpenDialog.this.updateCount();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.changeCombo.getCombo(), "com.perforce.team.ui.add_edit_delete_changes");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "com.perforce.team.ui.add_edit_delete_files");
        return dialogArea;
    }

    public void updateSelection() {
        Object[] elements = this.viewer.getCheckedElements();
        this.selectedFiles = new IP4Resource[elements.length];
        int i = 0;
        while (i < elements.length) {
            this.selectedFiles[i] = (IP4Resource)elements[i];
            ++i;
        }
    }

    protected void okPressed() {
        this.updateSelection();
        super.okPressed();
    }

    private PendingCombo createChangeCombo(Composite parent) {
        PendingCombo combo = new PendingCombo(this.comboTitle, (IP4Resource)this.connection);
        combo.setErrorDisplay(this);
        combo.createControl(parent, 1, this.selectedId, this.defaultDescription);
        return combo;
    }
}

