/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.DescriptionTemplate;
import com.perforce.team.ui.editor.IProposal;
import com.perforce.team.ui.editor.Proposal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class ChangelistDescriptionAssistant
extends ContentAssistant {
    private Set<IProposal> jobProposals = new TreeSet<IProposal>();
    private Set<IProposal> templateProposals = Collections.synchronizedSet(new TreeSet());
    private Set<IProposal> fileProposals = new TreeSet<IProposal>();
    private Set<Character> activatorSet = Collections.synchronizedSet(new HashSet());
    private Set<IProposal> contributedProposals = new TreeSet<IProposal>();
    private char[] activators = null;
    private Trigger keyTrigger = null;
    private IPropertyChangeListener prefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("com.perforce.team.ui.preferences.DESCRIPTION_AUTO_ACTIVATE".equals(event.getProperty())) {
                ChangelistDescriptionAssistant.this.enableAutoActivation(ChangelistDescriptionAssistant.this.autoActivate());
            }
        }
    };
    private Comparator<ICompletionProposal> comparator = new Comparator<ICompletionProposal>(){

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            return o1.getDisplayString().compareTo(o2.getDisplayString());
        }
    };

    private Trigger getContentAssistTrigger() {
        Trigger[] triggers;
        IBindingService service = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        Trigger trigger = null;
        TriggerSequence[] sequences = service.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (sequences.length > 0 && (triggers = sequences[0].getTriggers()).length > 0) {
            trigger = triggers[0];
        }
        return trigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCharArray() {
        StringBuilder activateString = new StringBuilder();
        Set<Character> set = this.activatorSet;
        synchronized (set) {
            for (Character c : this.activatorSet) {
                activateString.append(c);
            }
        }
        this.activators = activateString.toString().toCharArray();
    }

    private void loadProposals(IP4File[] files, IP4Job[] jobs, DescriptionTemplate[] templates) {
        this.fileProposals.clear();
        this.templateProposals.clear();
        IP4File[] iP4FileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IP4File file = iP4FileArray[n2];
            String remote = file.getRemotePath();
            this.fileProposals.add(new Proposal(remote));
            this.activatorSet.add(Character.valueOf(remote.charAt(0)));
            String name = file.getName();
            this.fileProposals.add(new Proposal(name));
            this.activatorSet.add(Character.valueOf(name.charAt(0)));
            int lastDot = name.lastIndexOf(46);
            if (lastDot > 0) {
                name = name.substring(0, lastDot);
                this.fileProposals.add(new Proposal(name));
                this.activatorSet.add(Character.valueOf(name.charAt(0)));
            }
            ++n2;
        }
        this.refreshTemplates(templates, false);
        this.refreshJobs(jobs, false);
        this.updateCharArray();
    }

    private void loadProcessor() {
        IContentAssistProcessor processor = new IContentAssistProcessor(){

            public String getErrorMessage() {
                return null;
            }

            public IContextInformationValidator getContextInformationValidator() {
                return null;
            }

            public char[] getContextInformationAutoActivationCharacters() {
                return null;
            }

            public char[] getCompletionProposalAutoActivationCharacters() {
                return ChangelistDescriptionAssistant.this.activators;
            }

            public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
                return null;
            }

            private String getPrefix(IDocument document, int offset) {
                StringBuilder builder = new StringBuilder();
                try {
                    char c = document.getChar(--offset);
                    while (!Character.isWhitespace(c)) {
                        builder.insert(0, c);
                        c = document.getChar(--offset);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return builder.toString();
            }

            public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
                String prefix = this.getPrefix(viewer.getDocument(), offset);
                TreeSet proposals = new TreeSet(ChangelistDescriptionAssistant.this.comparator);
                Point selection = viewer.getSelectedRange();
                int selectOffset = selection.x;
                int selectLength = selection.y;
                ChangelistDescriptionAssistant.this.createProposals(prefix, ChangelistDescriptionAssistant.this.fileProposals, proposals, offset, selectOffset, selectLength);
                ChangelistDescriptionAssistant.this.createProposals(prefix, ChangelistDescriptionAssistant.this.templateProposals, proposals, offset, selectOffset, selectLength);
                ChangelistDescriptionAssistant.this.createProposals(prefix, ChangelistDescriptionAssistant.this.jobProposals, proposals, offset, selectOffset, selectLength);
                ChangelistDescriptionAssistant.this.createProposals(prefix, ChangelistDescriptionAssistant.this.contributedProposals, proposals, offset, selectOffset, selectLength);
                return proposals.toArray(new ICompletionProposal[proposals.size()]);
            }
        };
        this.setContentAssistProcessor(processor, "__dftl_partition_content_type");
    }

    private ICompletionProposal createProposal(IProposal proposal, int offset, int prefix) {
        return this.createProposal(proposal, offset - prefix, prefix, proposal.getValue().length());
    }

    private ICompletionProposal createProposal(IProposal proposal, int replaceOffset, int replaceLength, int cursorOffset) {
        return new CompletionProposal(proposal.getValue(), replaceOffset, replaceLength, cursorOffset, proposal.getImage(), proposal.getDisplay(), null, null);
    }

    private void createProposals(String prefix, Set<IProposal> proposals, Set<ICompletionProposal> realProposals, int offset, int selectOffset, int selectLength) {
        int prefixLength = prefix.length();
        if (prefixLength > 0) {
            for (IProposal raw : proposals) {
                String display = raw.getDisplay();
                if (prefixLength < display.length()) {
                    String match = display.substring(0, prefixLength);
                    if (!match.equalsIgnoreCase(prefix)) continue;
                    ICompletionProposal prop = this.createProposal(raw, offset, prefixLength);
                    realProposals.add(prop);
                    continue;
                }
                if (prefixLength != display.length() || display.equals(prefix) || !display.equalsIgnoreCase(prefix)) continue;
                ICompletionProposal prop = this.createProposal(raw, offset, prefixLength);
                realProposals.add(prop);
            }
        } else {
            int length = selectOffset == offset && selectLength > 0 ? selectLength : 0;
            for (IProposal raw : proposals) {
                ICompletionProposal prop = this.createProposal(raw, offset, length, raw.getValue().length());
                realProposals.add(prop);
            }
        }
    }

    private void loadTrigger() {
        this.keyTrigger = this.getContentAssistTrigger();
    }

    private boolean autoActivate() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.preferences.DESCRIPTION_AUTO_ACTIVATE");
    }

    public void init(IP4File[] files, IP4Job[] jobs, DescriptionTemplate[] templates) {
        this.loadProposals(files, jobs, templates);
        this.loadProcessor();
        this.loadTrigger();
        this.enableAutoActivation(this.autoActivate());
        this.enablePrefixCompletion(true);
        this.enableAutoInsert(true);
    }

    private void refreshJobs(IP4Job[] jobs, boolean updateActivators) {
        this.jobProposals.clear();
        IP4Job[] iP4JobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Job job = iP4JobArray[n2];
            String name = job.getName();
            this.jobProposals.add(new Proposal(name));
            this.activatorSet.add(Character.valueOf(name.charAt(0)));
            ++n2;
        }
        if (updateActivators) {
            this.updateCharArray();
        }
    }

    public void updateJobs(IP4Job[] jobs) {
        this.refreshJobs(jobs, true);
    }

    private void refreshTemplates(DescriptionTemplate[] templates, boolean updateActivators) {
        this.templateProposals.clear();
        DescriptionTemplate[] descriptionTemplateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            DescriptionTemplate template = descriptionTemplateArray[n2];
            String content = template.getContent();
            if (content.length() > 0) {
                this.templateProposals.add(new Proposal(template.getContent()));
                this.activatorSet.add(Character.valueOf(content.charAt(0)));
            }
            ++n2;
        }
        if (updateActivators) {
            this.updateCharArray();
        }
    }

    public void updateTemplates(DescriptionTemplate[] templates) {
        this.refreshTemplates(templates, true);
    }

    public void install(ITextViewer textViewer) {
        if (this.keyTrigger != null) {
            textViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

                public void verifyKey(VerifyEvent event) {
                    KeyStroke stroke = KeyStroke.getInstance((int)event.stateMask, (int)(event.character != '\u0000' ? event.character : event.keyCode));
                    if (ChangelistDescriptionAssistant.this.keyTrigger.equals((Object)stroke)) {
                        event.doit = false;
                        ChangelistDescriptionAssistant.this.showPossibleCompletions();
                    }
                }
            });
        }
        PerforceUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener(this.prefListener);
        textViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PerforceUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener(ChangelistDescriptionAssistant.this.prefListener);
            }
        });
        super.install(textViewer);
    }

    public void addProposals(IProposal[] proposals) {
        if (proposals != null) {
            IProposal[] iProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                IProposal proposal = iProposalArray[n2];
                this.contributedProposals.add(proposal);
                this.activatorSet.add(Character.valueOf(proposal.getValue().charAt(0)));
                ++n2;
            }
        }
    }
}

