/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.core.IStreamSummary;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.streams.StreamsViewControl;
import com.perforce.team.ui.views.IPerforceView;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class BrowseStreamDialog
extends P4StatusDialog {
    private StreamsViewControl control;
    private IP4Connection connection;
    private IStreamSummary stream;
    private String info;

    public BrowseStreamDialog(Shell parent, IP4Connection connection, String info) {
        super(parent, Messages.BrowseStreamDialog_Title);
        this.connection = connection;
        this.info = info;
        this.setShellStyle(16);
    }

    public IStreamSummary getSelectedStream() {
        return this.stream;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        IPerforceView view = new IPerforceView(){

            @Override
            public IWorkbenchPartSite getSite() {
                return null;
            }

            @Override
            public Shell getShell() {
                return BrowseStreamDialog.this.getShell();
            }

            @Override
            public IP4Connection getConnection() {
                return BrowseStreamDialog.this.connection;
            }
        };
        this.control = new StreamsViewControl(view);
        this.control.createViewControl(dialogArea);
        this.control.enableAutoUpdate(true);
        this.control.enableDoubleClick(false);
        this.control.setVisible(true);
        this.control.showFilters(true);
        this.control.showDisplayDetails(true);
        this.control.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BrowseStreamDialog.this.validate();
            }
        });
        return dialogArea;
    }

    private void validate() {
        String errorMessage = null;
        IP4Stream stream = this.control.getSelectedStream();
        if (stream == null) {
            errorMessage = Messages.BrowseStreamDialog_NoStreamSelectedError;
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setInfoMessage(this.info);
        }
    }

    public void create() {
        super.create();
        this.getShell().setSize(1000, 800);
        this.validate();
    }

    protected void okPressed() {
        IP4Stream s = this.control.getSelectedStream();
        this.stream = s != null ? s.getStreamSummary() : null;
        super.okPressed();
    }
}

