/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4java.dialogs.MoveChangeDialog;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class MoveToAnotherChangelistAction
extends P4Action {
    @Override
    protected void runAction() {
        P4Collection collection = this.getFileSelection();
        IP4Resource[] members = collection.members();
        if (members.length > 0) {
            IP4Connection connection = members[0].getConnection();
            MoveChangeDialog dialog = new MoveChangeDialog(this.getShell(), connection.getCachedPendingChangelists());
            if (dialog.open() == 0) {
                int newChangelist = dialog.getSelectedChange();
                String description = dialog.getDescription();
                this.move(collection, newChangelist, description, connection);
            }
        }
    }

    private void move(final P4Collection collection, final int changelist, final String description, final IP4Connection connection) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                IP4PendingChangelist list = null;
                int work = changelist == -2 ? 2 : 1;
                monitor.beginTask(this.getTitle(), work);
                if (changelist == -2) {
                    monitor.subTask(Messages.MoveToAnotherChangelistAction_CreatingNewChangelist);
                    list = connection.createChangelist(description, null);
                    monitor.worked(1);
                } else {
                    list = connection.getPendingChangelist(changelist, true);
                }
                if (list != null) {
                    if (list.getId() == 0) {
                        monitor.subTask(Messages.MoveToAnotherChangelistAction_DefaultChangelist);
                    } else {
                        monitor.subTask(MessageFormat.format(Messages.MoveToAnotherChangelistAction_ChangelistNum, list.getId()));
                    }
                    collection.reopen(list);
                    monitor.worked(1);
                }
                monitor.done();
            }

            public String getTitle() {
                return Messages.MoveToAnotherChangelistAction_ReopeningPerforceResources;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    public void move(IP4PendingChangelist changelist) {
        P4Collection collection = this.getFileSelection();
        if (!collection.isEmpty()) {
            this.move(collection, changelist);
        }
    }

    public void move(final P4Collection collection, final IP4PendingChangelist changelist) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                collection.reopen(changelist);
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    public boolean isEnabledEx() {
        boolean enabled = false;
        if (this.containsOnlineConnection()) {
            P4Collection collection = this.getResourceSelection();
            IP4Resource[] iP4ResourceArray = collection.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File file;
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File && (file = (IP4File)resource).isOpened()) {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }
}

