/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.P4ClientUtil;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.ui.actions.Messages;
import com.perforce.team.ui.dialogs.CompareDialog;
import com.perforce.team.ui.dialogs.PerforceEditorInput;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ManualResolveAction
extends P4Action {
    public IP4File runManualResolve(IP4File file, int whichIntegSpec) {
        CompareDialog dialog = this.createManualResolveDialog(file, whichIntegSpec);
        if (dialog == null || dialog.open() != 0) {
            return null;
        }
        P4Collection single = this.createCollection(new IP4Resource[]{file});
        single.setType(IP4Resource.Type.LOCAL);
        try {
            IFileSpec spec = file.getIntegrationSpecs()[whichIntegSpec];
            IP4Resource[] resolved = single.resolve(file.getLocalFiles()[0].getContents(), true, spec.getStartFromRev(), spec.getEndFromRev());
            if (resolved.length == 1 && resolved[0] instanceof IP4File) {
                return (IP4File)resolved[0];
            }
            return null;
        }
        catch (CoreException e) {
            PerforceProviderPlugin.logError((Throwable)e);
            return null;
        }
    }

    public CompareDialog createManualResolveDialog(IP4File file, int which) {
        CompareDialog dialog = null;
        IFileSpec spec = file.getIntegrationSpecs()[which];
        if (spec != null) {
            IP4File foundFromFile;
            IP4File from = file;
            String fromFile = spec.getFromFile();
            int baseRev = P4ClientUtil.getBaseRev((IFileSpec)spec);
            String baseFile = P4ClientUtil.getBaseFile((IFileSpec)spec);
            if (fromFile != null && (foundFromFile = file.getConnection().getFile(fromFile)) != null) {
                from = foundFromFile;
            }
            String toRev = P4ClientUtil.computeTheirRev((IFileSpec)spec);
            IP4File base = file.getConnection().getFile(baseFile);
            File ancestor = null;
            if (baseRev != -1 && base != null) {
                ancestor = P4CoreUtils.createFile((InputStream)base.getRemoteContents(baseRev));
            }
            File depot = P4CoreUtils.createFile((InputStream)from.getRemoteContents(toRev));
            File current = new File(file.getLocalPath());
            if (depot != null && current != null) {
                String type = new Path(file.getLocalPath()).getFileExtension();
                PerforceEditorInput input = new PerforceEditorInput(Messages.ManualResolveAction_EDITORTITLE, true, type, file.getLocalPath(), NLS.bind((String)Messages.ManualResolveAction_FILETITLE, (Object)file.getName()), depot.getPath(), NLS.bind((String)Messages.ManualResolveAction_DEPOTTITLE, (Object)from.getName(), (Object)toRev), ancestor != null ? ancestor.getPath() : null, NLS.bind((String)Messages.ManualResolveAction_BASEFILE, (Object)(base != null ? base.getName() : ""), (Object)baseRev));
                dialog = CompareDialog.createCompareDialog(this.getShell(), input);
            }
        }
        return dialog;
    }

    @Override
    protected void runAction() {
    }
}

