/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.runtime.IProgressMonitor;

public class LockAction
extends P4Action {
    @Override
    protected void runAction() {
        P4Collection collection = this.getResourceSelection();
        if (!collection.isEmpty()) {
            this.lock(collection);
        }
    }

    private void lock(final P4Collection collection) {
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return Messages.LockAction_Locking;
            }

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 1);
                monitor.subTask(LockAction.this.generateTitle(null, collection));
                collection.lock();
                monitor.worked(1);
                monitor.done();
                LockAction.this.updateActionState();
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    public boolean isEnabledEx() {
        P4Collection collection;
        IP4Resource[] resources;
        int size;
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers()) && (size = (resources = (collection = super.getResourceSelection()).members()).length) > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    IP4File file = (IP4File)resource;
                    if ((file.openedForEdit() || file.openedForDelete()) && !file.isLocked()) {
                        enabled = true;
                        break;
                    }
                } else {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }
}

