/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.OpenAction;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.TeamException;

public class DeleteAction
extends OpenAction {
    @Override
    protected boolean isEnabledEx() throws TeamException {
        P4Collection collection;
        IP4Resource[] resources;
        int size;
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers()) && (size = (resources = (collection = super.getResourceSelection()).members()).length) > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    IP4File file = (IP4File)resource;
                    if (this.isValidFile(file)) {
                        enabled = true;
                        break;
                    }
                } else {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }

    private boolean isRmdirResource(IP4Resource resource) {
        boolean rmdir = false;
        IClient client = resource.getClient();
        if (client != null) {
            IClientSummary.IClientOptions options = client.getOptions();
            rmdir = options != null && options.isRmdir();
        }
        return rmdir;
    }

    private void handleRmdirClientRefresh(P4Collection collection) {
        IP4Resource[] iP4ResourceArray = collection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (this.isRmdirResource(resource)) {
                IContainer[] refreshContainers = null;
                if (resource instanceof IP4File) {
                    IFile localFile = ((IP4File)resource).getLocalFileForLocation();
                    if (localFile != null) {
                        refreshContainers = new IContainer[]{localFile.getParent()};
                    }
                } else if (resource instanceof IP4Folder) {
                    refreshContainers = ((IP4Folder)resource).getLocalContainers();
                }
                if (refreshContainers != null) {
                    IContainer[] iContainerArray = refreshContainers;
                    int n3 = refreshContainers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        final IContainer refresh = iContainerArray[n4];
                        if (refresh != null) {
                            Job job = new Job("Refresh deleted empty folders..."){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        refresh.refreshLocal(1, null);
                                    }
                                    catch (CoreException e) {
                                        PerforceProviderPlugin.logError((Throwable)e);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            job.setRule(workspace.getRuleFactory().refreshRule((IResource)refresh));
                            job.schedule();
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private void delete(final P4Collection collection, final int changelist, final String description, final boolean setActive) {
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return DeleteAction.this.getJobTitle();
            }

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 1);
                monitor.subTask(DeleteAction.this.generateTitle(null, collection));
                collection.delete(changelist, description, setActive);
                monitor.worked(1);
                monitor.done();
                collection.refreshLocalResources(1);
                DeleteAction.this.handleRmdirClientRefresh(collection);
                DeleteAction.this.updateActionState();
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    protected void runModifyAction(int changelist, String description, P4Collection collection, boolean setActive) {
        this.delete(collection, changelist, description, setActive);
    }

    @Override
    public String getComboTitle() {
        return Messages.DeleteAction_OpenInChangelist;
    }

    @Override
    public String getDialogTitle() {
        return Messages.DeleteAction_MarkForDelete;
    }

    @Override
    protected boolean isValidFile(IP4File file) {
        return file.getP4JFile() != null && !file.isOpened();
    }

    @Override
    protected String getJobTitle() {
        return Messages.DeleteAction_MarkingForDelete;
    }

    @Override
    protected String getDefaultDescription() {
        return P4Collection.DELETE_DEFAULT_DESCRIPTION;
    }
}

