/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4java.dialogs.CheckConsistencyDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class CheckConsistencyAction
extends P4Action {
    private P4Collection getCollection(IFile[] files) {
        P4Collection collection = this.createCollection();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            IP4Resource resource = P4ConnectionManager.getManager().getResource((IResource)file);
            if (resource instanceof IP4File) {
                collection.add(resource);
            }
            ++n2;
        }
        return collection;
    }

    private void openFiles(IP4Connection con, CheckConsistencyDialog dlg) {
        P4Collection addCollection;
        IFile[] newFiles;
        P4Collection deleteCollection;
        IFile[] missingFiles;
        P4Collection diffCollection;
        IFile[] diffFiles;
        int pendingId = dlg.getSelectedChange();
        String pendingDescription = dlg.getSelectedDescription();
        if (pendingId == -2) {
            IP4PendingChangelist created = con.createChangelist(pendingDescription, null);
            pendingId = created != null ? created.getId() : 0;
        }
        if ((diffFiles = dlg.getDiffFiles()) != null && diffFiles.length > 0 && !(diffCollection = this.getCollection(diffFiles)).isEmpty()) {
            diffCollection.edit(pendingId);
        }
        if ((missingFiles = dlg.getMissingFiles()) != null && missingFiles.length > 0 && !(deleteCollection = this.getCollection(missingFiles)).isEmpty()) {
            deleteCollection.delete(pendingId);
        }
        if ((newFiles = dlg.getNewFiles()) != null && newFiles.length > 0 && !(addCollection = this.getCollection(newFiles)).isEmpty()) {
            addCollection.add(pendingId);
        }
    }

    private void doneWork(IProgressMonitor monitor) throws InterruptedException {
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private void getDiffResources(IP4Connection con, String[] paths, List<IFile> list) {
        IFileSpec[] specs = con.getDifferingFiles(paths);
        ArrayList<String> clientFiles = new ArrayList<String>();
        IFileSpec[] iFileSpecArray = specs;
        int n = specs.length;
        int n2 = 0;
        while (n2 < n) {
            IFileSpec spec = iFileSpecArray[n2];
            String path = P4Resource.normalizeLocalPath((IFileSpec)spec);
            if (path != null) {
                clientFiles.add(path);
            }
            ++n2;
        }
        this.addFilesToList(clientFiles.toArray(new String[0]), list);
    }

    private void getMissingResources(IP4Connection con, String[] paths, List<IFile> list) {
        IFileSpec[] specs = con.getMissingFiles(paths);
        ArrayList<String> clientFiles = new ArrayList<String>();
        IFileSpec[] iFileSpecArray = specs;
        int n = specs.length;
        int n2 = 0;
        while (n2 < n) {
            IP4File file;
            IFileSpec spec = iFileSpecArray[n2];
            String path = P4Resource.normalizeLocalPath((IFileSpec)spec);
            if (!(path == null || (file = con.getFile(spec)) != null && file.openedForDelete())) {
                clientFiles.add(path);
            }
            ++n2;
        }
        this.addFilesToList(clientFiles.toArray(new String[0]), list);
    }

    private void getNewResources(IP4Connection con, IContainer folder, List<IFile> list) {
        IP4Resource resource = con.getResource((IResource)folder);
        if (resource instanceof IP4Container) {
            IP4Container p4Container = (IP4Container)resource;
            p4Container.refresh();
        }
        try {
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                IP4Resource foundResource;
                if (members[i] instanceof IFile && (foundResource = con.getResource(members[i])) instanceof IP4File && this.isNewFile((IFile)members[i], (IP4File)foundResource)) {
                    list.add((IFile)members[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
    }

    private void getNewResources(IP4Connection con, IFile[] files, List<IFile> list) {
        int i = 0;
        while (i < files.length) {
            IP4File p4File;
            IP4Resource p4Resource = con.getResource((IResource)files[i]);
            if (p4Resource instanceof IP4File && this.isNewFile(files[i], p4File = (IP4File)p4Resource)) {
                list.add(files[i]);
            }
            ++i;
        }
    }

    private boolean isNewFile(IFile localFile, IP4File p4File) {
        boolean isNew = false;
        if (!this.isResourceIgnored((IResource)localFile)) {
            if (p4File == null) {
                isNew = true;
            } else if (p4File.getP4JFile() == null) {
                isNew = true;
            } else if (p4File.getAction() == null && p4File.isHeadActionDelete()) {
                isNew = true;
            }
        }
        return isNew;
    }

    private void getFoldersFiles(IResource[] resources, final List<IContainer> folders, List<IResource> files) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IContainer) {
                try {
                    resources[i].accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource instanceof IContainer) {
                                folders.add((IContainer)resource);
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
            } else if (resources[i] instanceof IFile) {
                files.add(resources[i]);
            }
            ++i;
        }
    }

    private String getDiffFolderPath(IResource folder) {
        return String.valueOf(PerforceProviderPlugin.getResourcePath((IResource)folder)) + File.separatorChar + "*";
    }

    private String getMissingFolderPath(IResource folder) {
        return String.valueOf(PerforceProviderPlugin.getResourcePath((IResource)folder)) + File.separatorChar + "...";
    }

    private void addFilesToList(String[] paths, List<IFile> list) {
        IFile[] files = PerforceProviderPlugin.getWorkspaceFiles((String[])paths);
        int i = 0;
        while (i < files.length) {
            if (!list.contains(files[i])) {
                list.add(files[i]);
            }
            ++i;
        }
    }

    @Override
    protected void runAction() {
        final Map<IP4Connection, List<IResource>> providerMap = this.getProviderMap();
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                final ArrayList<Consistency> consistencies = new ArrayList<Consistency>();
                for (IP4Connection connection : providerMap.keySet()) {
                    Consistency consistency;
                    List resourceList = (List)providerMap.get(connection);
                    IResource[] resources = resourceList.toArray(new IResource[resourceList.size()]);
                    if (resources.length <= 0 || (consistency = CheckConsistencyAction.this.calculateConsistency(connection, resources, monitor)) == null) continue;
                    consistencies.add(consistency);
                }
                if (!consistencies.isEmpty()) {
                    PerforceUIPlugin.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CheckConsistencyAction.this.displayDialog(consistencies.toArray(new Consistency[consistencies.size()]));
                        }
                    });
                }
            }

            public String getTitle() {
                return Messages.CheckConsistencyAction_CheckingConsistency;
            }
        };
        if (this.isAsync()) {
            Job ccJob = new Job(runnable.getTitle(), (IP4Runnable)runnable){
                private final /* synthetic */ IP4Runnable val$runnable;
                {
                    this.val$runnable = iP4Runnable;
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    this.val$runnable.run(monitor);
                    return Status.OK_STATUS;
                }
            };
            PlatformUI.getWorkbench().getProgressService().showInDialog(this.getShell(), ccJob);
            ccJob.schedule();
        } else {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public Consistency calculateConsistency(IP4Connection connection, IResource[] resources, IProgressMonitor monitor) {
        Consistency consistency = new Consistency();
        consistency.connection = connection;
        monitor.setTaskName(Messages.CheckConsistencyAction_RefreshingResources);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            try {
                resource.refreshLocal(2, monitor);
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            ++n2;
        }
        ArrayList<IContainer> folders = new ArrayList<IContainer>();
        ArrayList<IResource> files = new ArrayList<IResource>();
        this.getFoldersFiles(resources, folders, files);
        ArrayList<IFile> diffList = new ArrayList<IFile>();
        ArrayList<IFile> missingList = new ArrayList<IFile>();
        ArrayList<IFile> newList = new ArrayList<IFile>();
        try {
            int numTasks = folders.size();
            if (files.size() > 0) {
                ++numTasks;
            }
            monitor.beginTask(Messages.CheckConsistencyAction_TASKTITLE, numTasks *= 3);
            for (IContainer folder : folders) {
                String diffPath = this.getDiffFolderPath((IResource)folder);
                String missingPath = this.getMissingFolderPath((IResource)folder);
                monitor.subTask(NLS.bind((String)Messages.CheckConsistencyAction_FOLDERTASKTITLE, (Object)folder.getFullPath()));
                this.getNewResources(connection, folder, newList);
                this.doneWork(monitor);
                this.getDiffResources(connection, new String[]{diffPath}, diffList);
                this.doneWork(monitor);
                this.getMissingResources(connection, new String[]{missingPath}, missingList);
                this.doneWork(monitor);
            }
            if (files.size() > 0) {
                IFile[] fileResources = files.toArray(new IFile[files.size()]);
                String[] paths = PerforceProviderPlugin.getResourcePath((IResource[])fileResources);
                monitor.subTask(Messages.CheckConsistencyAction_CHECKINGFILE);
                this.getDiffResources(connection, paths, diffList);
                this.doneWork(monitor);
                this.getMissingResources(connection, paths, missingList);
                this.doneWork(monitor);
                this.getNewResources(connection, fileResources, newList);
                this.doneWork(monitor);
            }
        }
        catch (InterruptedException e) {
            consistency.diffFiles = null;
            consistency.missingFiles = null;
            consistency.newFiles = null;
            return consistency;
        }
        consistency.diffFiles = diffList.toArray(new IFile[diffList.size()]);
        consistency.missingFiles = missingList.toArray(new IFile[missingList.size()]);
        consistency.newFiles = newList.toArray(new IFile[newList.size()]);
        return consistency;
    }

    private void displayDialog(Consistency[] consistencies) {
        Consistency[] consistencyArray = consistencies;
        int n = consistencies.length;
        int n2 = 0;
        while (n2 < n) {
            Consistency consistency = consistencyArray[n2];
            if (consistency.diffFiles != null && consistency.newFiles != null && consistency.missingFiles != null && consistency.connection != null) {
                if (consistency.diffFiles.length > 0 || consistency.missingFiles.length > 0 || consistency.newFiles.length > 0) {
                    CheckConsistencyDialog dlg = new CheckConsistencyDialog(P4UIUtils.getDialogShell(), consistency.connection, consistency.diffFiles, consistency.missingFiles, consistency.newFiles);
                    if (dlg.open() == 0) {
                        this.openFiles(consistency.connection, dlg);
                    }
                } else {
                    P4ConnectionManager.getManager().openInformation(this.getShell(), Messages.CheckConsistencyAction_DIALOGTITLE, Messages.CheckConsistencyAction_DIALOGMESSAGE);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean isEnabledEx() {
        return this.containsOnlineConnection();
    }

    public static class Consistency {
        public IFile[] diffFiles;
        public IFile[] missingFiles;
        public IFile[] newFiles;
        public IP4Connection connection;
    }
}

