/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.labels;

import com.perforce.team.ui.BaseErrorProvider;
import com.perforce.team.ui.labels.Messages;
import com.perforce.team.ui.p4java.dialogs.VersionComboViewer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VersionWidget
extends BaseErrorProvider {
    private Button latestRevisionButton;
    private Button specificRevisionButton;
    private Text revisionText;
    private VersionComboViewer revisionCombo;
    private String version = null;
    private static Map<VersionComboViewer.VersionType, String> errorMap = new HashMap<VersionComboViewer.VersionType, String>();
    private static Map<VersionComboViewer.VersionType, String> patternMap = new HashMap<VersionComboViewer.VersionType, String>();

    static {
        errorMap.put(VersionComboViewer.VersionType.Revision, Messages.VersionWidget_MustEnterRevisionNumber);
        errorMap.put(VersionComboViewer.VersionType.ChangeList, Messages.VersionWidget_MustEnterChangelistNumber);
        errorMap.put(VersionComboViewer.VersionType.Datetime, Messages.VersionWidget_MustEnterDate);
        errorMap.put(VersionComboViewer.VersionType.Label, Messages.VersionWidget_MustEnterLabelName);
        patternMap.put(VersionComboViewer.VersionType.Revision, "#\\d+");
        patternMap.put(VersionComboViewer.VersionType.ChangeList, "@\\d+");
        patternMap.put(VersionComboViewer.VersionType.Datetime, "@((19|20)\\d\\d)/(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01])(:([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])?");
        patternMap.put(VersionComboViewer.VersionType.Label, "@.+");
    }

    public Composite createControl(Composite parent) {
        Composite revisionArea = new Composite(parent, 0);
        GridLayout raLayout = new GridLayout(3, false);
        raLayout.marginHeight = 0;
        raLayout.marginWidth = 0;
        revisionArea.setLayout((Layout)raLayout);
        final ModifyListener textListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = VersionWidget.this.revisionText.getText().trim();
                String first = "@";
                if (VersionWidget.this.revisionCombo.getSelectedObject() == VersionComboViewer.VersionType.Revision) {
                    first = "#";
                }
                VersionWidget.this.version = text.startsWith(first) ? text : String.valueOf(first) + text;
                VersionWidget.this.validate();
            }
        };
        SelectionAdapter revisionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VersionWidget.this.revisionText.setEnabled(VersionWidget.this.specificRevisionButton.getSelection());
                VersionWidget.this.revisionCombo.setEnabled(VersionWidget.this.specificRevisionButton.getSelection());
                if (VersionWidget.this.latestRevisionButton.getSelection()) {
                    VersionWidget.this.version = null;
                } else {
                    textListener.modifyText(new ModifyEvent(new Event()));
                }
                VersionWidget.this.validate();
            }
        };
        this.latestRevisionButton = new Button(revisionArea, 16);
        this.latestRevisionButton.setText(Messages.LabelFilesWidget_AtLatestRevision);
        this.latestRevisionButton.setSelection(true);
        GridData lrbData = new GridData(4, 4, true, false);
        lrbData.horizontalSpan = 3;
        this.latestRevisionButton.setLayoutData((Object)lrbData);
        this.latestRevisionButton.addSelectionListener((SelectionListener)revisionListener);
        this.specificRevisionButton = new Button(revisionArea, 16);
        this.specificRevisionButton.setText(Messages.LabelFilesWidget_SpecifyRevision);
        this.specificRevisionButton.addSelectionListener((SelectionListener)revisionListener);
        this.revisionCombo = new VersionComboViewer(revisionArea, 12);
        this.revisionCombo.select(VersionComboViewer.VersionType.Revision);
        this.revisionCombo.addSelectionChangedListener(new ISelectionChangedListener((SelectionListener)revisionListener){
            private final /* synthetic */ SelectionListener val$revisionListener;
            {
                this.val$revisionListener = selectionListener;
            }

            public void selectionChanged(SelectionChangedEvent event) {
                this.val$revisionListener.widgetSelected(null);
            }
        });
        this.revisionText = new Text(revisionArea, 2052);
        this.revisionText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.revisionText.addModifyListener(textListener);
        revisionListener.widgetSelected(null);
        return revisionArea;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        VersionComboViewer.VersionType type = this.getType(version);
        if (type == null) {
            this.latestRevisionButton.setSelection(true);
            this.specificRevisionButton.setSelection(false);
        } else {
            this.latestRevisionButton.setSelection(false);
            this.specificRevisionButton.setSelection(true);
            this.revisionCombo.select(type);
            this.revisionText.setText(version.substring(1));
        }
    }

    public void filterVersion(VersionComboViewer.VersionType ... types) {
        this.revisionCombo.filter(types);
        this.revisionCombo.refresh();
    }

    @Override
    public void validate() {
        if (this.specificRevisionButton.getSelection()) {
            VersionComboViewer.VersionType type = this.revisionCombo.getSelectedObject();
            this.errorMessage = this.version != null && !this.version.matches(patternMap.get((Object)type)) ? errorMap.get((Object)type) : null;
        }
        super.validate();
    }

    public VersionComboViewer.VersionType getType(String type) {
        if (type != null) {
            VersionComboViewer.VersionType[] versionTypeArray = VersionComboViewer.VersionType.values();
            int n = versionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                VersionComboViewer.VersionType t = versionTypeArray[n2];
                String pattern = patternMap.get((Object)t);
                if (type.matches(pattern)) {
                    return t;
                }
                ++n2;
            }
        }
        return null;
    }
}

