/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.labels;

import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.BaseErrorProvider;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.labels.Messages;
import com.perforce.team.ui.labels.SelectLabelDialog;
import com.perforce.team.ui.labels.VersionWidget;
import com.perforce.team.ui.p4java.dialogs.VersionComboViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LabelFilesWidget
extends BaseErrorProvider {
    private Composite displayArea;
    private Text nameText;
    private Button browseButton;
    private Button addButton;
    private Button removeButton;
    private VersionWidget versionWidget = new VersionWidget();
    private IP4Resource[] resources;
    private IP4Resource.Type type;
    private boolean delete = false;
    private String selectedLabel = null;

    public LabelFilesWidget(IP4Resource[] resources, IP4Resource.Type type) {
        this.resources = resources;
        this.type = type;
    }

    private void createLabelArea(Composite parent) {
        Composite labelArea = new Composite(parent, 0);
        labelArea.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout laLayout = new GridLayout(3, false);
        laLayout.marginWidth = 0;
        laLayout.marginHeight = 0;
        labelArea.setLayout((Layout)laLayout);
        Label nameLabel = new Label(labelArea, 0);
        nameLabel.setText(Messages.LabelFilesWidget_Name);
        this.nameText = new Text(labelArea, 2052);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LabelFilesWidget.this.selectedLabel = LabelFilesWidget.this.nameText.getText();
                LabelFilesWidget.this.validate();
            }
        });
        this.browseButton = new Button(labelArea, 8);
        this.browseButton.setText(Messages.LabelFilesWidget_Browse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IP4Label selected;
                SelectLabelDialog dialog;
                if (LabelFilesWidget.this.resources.length > 0 && (dialog = new SelectLabelDialog(LabelFilesWidget.this.browseButton.getShell(), LabelFilesWidget.this.resources[0].getConnection())).open() == 0 && (selected = dialog.getSelected()) != null && selected.getName() != null) {
                    LabelFilesWidget.this.nameText.setText(selected.getName());
                    LabelFilesWidget.this.selectedLabel = selected.getName();
                    LabelFilesWidget.this.validate();
                }
            }
        });
    }

    private void createFilesArea(Composite parent) {
        Composite filesArea = new Composite(parent, 0);
        filesArea.setLayout((Layout)new GridLayout(1, true));
        filesArea.setLayoutData((Object)new GridData(4, 4, true, true));
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelFilesWidget.this.delete = LabelFilesWidget.this.removeButton.getSelection();
            }
        };
        this.addButton = new Button(filesArea, 16);
        this.addButton.setText(Messages.LabelFilesWidget_ApplySelectedLabelToFiles);
        this.addButton.setSelection(true);
        this.addButton.addSelectionListener((SelectionListener)buttonListener);
        this.removeButton = new Button(filesArea, 16);
        this.removeButton.setText(Messages.LabelFilesWidget_RemoveSelectedLabelFromFiles);
        this.removeButton.addSelectionListener((SelectionListener)buttonListener);
        Label filesLabel = new Label(filesArea, 16384);
        filesLabel.setText(Messages.LabelFilesWidget_Files);
        TableViewer filesViewer = new TableViewer(filesArea, 68356);
        GridData fvData = new GridData(4, 4, true, true);
        fvData.heightHint = 100;
        filesViewer.getTable().setLayoutData((Object)fvData);
        filesViewer.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider(false){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof IP4Resource) {
                    return ((IP4Resource)element).getActionPath(LabelFilesWidget.this.type);
                }
                return super.getColumnText(element, columnIndex);
            }
        });
        filesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        filesViewer.setInput((Object)this.resources);
    }

    private void createRevisionArea(Composite parent) {
        this.versionWidget.createControl(parent).setLayoutData((Object)new GridData(4, 4, true, false));
        this.versionWidget.filterVersion(VersionComboViewer.VersionType.Revision, VersionComboViewer.VersionType.ChangeList, VersionComboViewer.VersionType.Datetime);
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLabelArea(this.displayArea);
        this.createFilesArea(this.displayArea);
        this.createRevisionArea(this.displayArea);
    }

    public boolean deleteFromLabel() {
        return this.delete;
    }

    public String getSelectedLabel() {
        return this.selectedLabel;
    }

    public String getRevision() {
        return this.versionWidget.getVersion();
    }

    @Override
    public void validate() {
        this.errorMessage = null;
        String name = this.nameText.getText().trim();
        if (name.length() == 0) {
            this.errorMessage = Messages.VersionWidget_MustEnterLabelName;
        } else {
            this.versionWidget.validate();
            this.errorMessage = this.versionWidget.getErrorMessage();
        }
        super.validate();
    }
}

