/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.P4Storage;
import com.perforce.team.ui.editor.P4BaseEditorInput;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class RevisionEditorInput
extends P4BaseEditorInput {
    protected IP4Revision revision = null;

    public RevisionEditorInput(IP4Revision revision) {
        this.revision = revision;
    }

    @Override
    protected String getSuffix() {
        int lastDot;
        String name = this.revision.getRemotePath();
        if (name != null && (lastDot = name.lastIndexOf(46)) > 0) {
            return name.substring(lastDot);
        }
        return super.getSuffix();
    }

    @Override
    protected String getPrefix() {
        int lastDot;
        String name = this.revision.getName();
        if (name != null && (lastDot = name.lastIndexOf(46)) > 0) {
            return name.substring(0, lastDot);
        }
        return super.getSuffix();
    }

    protected IStorage getWrappedStorage() throws CoreException {
        return this.revision.getStorage((IProgressMonitor)new NullProgressMonitor());
    }

    public IStorage getStorage() throws CoreException {
        if (this.storage == null) {
            final IStorage wrapStorage = this.getWrappedStorage();
            this.storage = new P4Storage(){

                public IPath getFullPath() {
                    return RevisionEditorInput.this.getTempStoragePath();
                }

                public String getName() {
                    return wrapStorage.getName();
                }

                public InputStream getContents() throws CoreException {
                    return RevisionEditorInput.this.getStorageContents(wrapStorage);
                }
            };
        }
        return this.storage;
    }

    public String getName() {
        return String.valueOf(this.revision.getName()) + " #" + this.revision.getRevision();
    }

    public String getToolTipText() {
        return this.revision.getContentIdentifier();
    }
}

