/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.diff;

import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.decorator.OverlayIcon;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class DiffLabelProvider
extends PerforceLabelProvider {
    protected CompareConfiguration configuration;
    private Map<OverlayIcon, Image> enlarged = new HashMap<OverlayIcon, Image>();

    public DiffLabelProvider() {
        this(new CompareConfiguration());
    }

    public DiffLabelProvider(CompareConfiguration configuration) {
        this.configuration = configuration;
    }

    public DiffLabelProvider(boolean decorateResources) {
        this(new CompareConfiguration(), decorateResources);
    }

    public DiffLabelProvider(boolean decorateResources, boolean decorateText, boolean decorateImages) {
        this(new CompareConfiguration(), decorateResources, decorateText, decorateImages);
    }

    public DiffLabelProvider(CompareConfiguration configuration, boolean decorateResources, boolean decorateText, boolean decorateImages) {
        super(decorateResources, decorateText, decorateImages);
        this.configuration = configuration;
    }

    public DiffLabelProvider(CompareConfiguration configuration, boolean decorateResources) {
        super(decorateResources);
        this.configuration = configuration;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.configuration.dispose();
        for (Image image : this.enlarged.values()) {
            image.dispose();
        }
    }

    protected Image enlargeImage(Image orig) {
        OverlayIcon bigger = new OverlayIcon(orig, new ImageDescriptor[0], new int[0], 22, orig.getBounds().height, 0, 0);
        Image converted = this.enlarged.get((Object)bigger);
        if (converted == null) {
            converted = bigger.createImage();
            this.enlarged.put(bigger, converted);
        }
        return converted;
    }

    protected Image getDiffImage(IDiffElement diff) {
        return this.configuration.getImage(diff.getImage(), diff.getKind());
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof IDiffElement) {
            return this.getDiffImage((IDiffElement)element);
        }
        Image orig = super.getColumnImage(element, columnIndex);
        if (orig != null) {
            return this.enlargeImage(orig);
        }
        return null;
    }
}

