/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.diff;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.diff.IFileDiffer;
import com.perforce.team.ui.diff.Messages;
import com.perforce.team.ui.editor.P4StorageNode;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class BaseFileDiffer
implements IFileDiffer {
    private Map<IP4Resource, Object[]> diffs = new HashMap<IP4Resource, Object[]>();

    protected abstract IStructureCreator getStructureCreator();

    protected abstract Object[] formatDiffs(IDiffContainer var1);

    @Override
    public boolean diffGenerated(IP4Resource file) {
        return this.diffs.containsKey(file);
    }

    @Override
    public void dispose() {
        this.diffs.clear();
    }

    @Override
    public void generateDiff(IP4Resource resource, IP4File file, IStorage storage1, IStorage storage2) {
        String ext = new Path(file.getName()).getFileExtension();
        P4StorageNode prev = new P4StorageNode(storage1, Messages.BaseFileDiffer_Left, ext);
        P4StorageNode curr = new P4StorageNode(storage2, Messages.BaseFileDiffer_Right, ext);
        Differencer differ = new Differencer();
        IStructureCreator creator = this.getStructureCreator();
        prev = creator.getStructure((Object)prev);
        IDiffContainer allDiffs = (IDiffContainer)differ.findDifferences(false, (IProgressMonitor)new NullProgressMonitor(), null, null, (Object)prev, (Object)(curr = creator.getStructure((Object)curr)));
        if (allDiffs != null) {
            Object[] formatted = this.formatDiffs(allDiffs);
            this.diffs.put(resource, formatted);
            this.diffs.put((IP4Resource)file, formatted);
        } else {
            this.diffs.put(resource, PerforceContentProvider.EMPTY);
            this.diffs.put((IP4Resource)file, PerforceContentProvider.EMPTY);
        }
    }

    @Override
    public Object[] getDiff(IP4Resource file) {
        Object[] diffs = null;
        if (file != null) {
            diffs = this.diffs.get(file);
        }
        if (diffs == null) {
            diffs = PerforceContentProvider.EMPTY;
        }
        return diffs;
    }
}

