/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.dialogs.JobsDialog;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.dialogs.PerforceDialog;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class JobColumnsDialog
extends PerforceDialog {
    private JobsDialog jobsList;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private List availableList;
    private List showList;

    public JobColumnsDialog(Shell parent, JobsDialog jobsList) {
        super(parent, Messages.JobColumnsDialog_SetJobViewColumns);
        this.jobsList = jobsList;
    }

    protected void okPressed() {
        this.jobsList.saveDisplayColumns(this.showList.getItems());
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = this.createComposite(dialogArea, 3, 1808);
        Composite hiddenGroup = this.createTitledArea(composite, 1808);
        this.createLabel(hiddenGroup, "These columns may be added:");
        this.availableList = this.createList(hiddenGroup, 1, 300, 200, false);
        Composite buttonGroup = this.createTitledArea(composite, 1808);
        this.createLabel(buttonGroup, "");
        this.addButton = this.createButton(buttonGroup, Messages.JobColumnsDialog_Add, 768);
        this.removeButton = this.createButton(buttonGroup, Messages.JobColumnsDialog_Remove, 768);
        this.upButton = this.createButton(buttonGroup, Messages.JobColumnsDialog_MoveUp, 768);
        this.downButton = this.createButton(buttonGroup, Messages.JobColumnsDialog_MoveDown, 768);
        Composite shownGroup = this.createTitledArea(composite, 1808);
        this.createLabel(shownGroup, "Show these columns:");
        this.showList = this.createList(shownGroup, 1, 300, 200, false);
        this.initLists();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.addEventListeners();
        return composite;
    }

    private void showListButtons() {
        int idx = this.showList.getSelectionIndex();
        int count = this.showList.getItemCount();
        this.addButton.setEnabled(false);
        if (idx > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
        if (idx > 1 && idx < count - 1) {
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
        } else if (idx > 1) {
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(false);
        } else if (idx > 0 && idx < count - 1) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(true);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    private void availableListButtons() {
        this.removeButton.setEnabled(false);
        this.addButton.setEnabled(true);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    private void addEventListeners() {
        this.showList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobColumnsDialog.this.availableList.deselectAll();
                JobColumnsDialog.this.showListButtons();
            }
        });
        this.availableList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobColumnsDialog.this.showList.deselectAll();
                JobColumnsDialog.this.availableListButtons();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobColumnsDialog.this.addSelection();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobColumnsDialog.this.removeSelection();
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = JobColumnsDialog.this.showList.getSelectionIndex();
                String item = JobColumnsDialog.this.showList.getItem(idx);
                JobColumnsDialog.this.showList.remove(idx);
                JobColumnsDialog.this.showList.add(item, idx - 1);
                JobColumnsDialog.this.showList.setSelection(idx - 1);
                JobColumnsDialog.this.showListButtons();
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = JobColumnsDialog.this.showList.getSelectionIndex();
                String item = JobColumnsDialog.this.showList.getItem(idx);
                JobColumnsDialog.this.showList.remove(idx);
                JobColumnsDialog.this.showList.add(item, idx + 1);
                JobColumnsDialog.this.showList.setSelection(idx + 1);
                JobColumnsDialog.this.showListButtons();
            }
        });
    }

    private void initLists() {
        HashMap<String, String> showLookup = new HashMap<String, String>();
        String[] showNames = this.jobsList.getDisplayColumns();
        int i = 0;
        while (i < showNames.length) {
            String name = showNames[i];
            this.showList.add(name);
            showLookup.put(name, name);
            ++i;
        }
        String[] fields = this.jobsList.getFieldNames();
        int i2 = 0;
        while (i2 < fields.length) {
            String name = fields[i2];
            if (showLookup.get(name) == null) {
                this.availableList.add(name);
            }
            ++i2;
        }
    }

    public void selectShowColumn(String column) {
        this.showList.select(this.showList.indexOf(column));
        this.showListButtons();
    }

    public void selectAvailableColumn(String column) {
        this.availableList.select(this.availableList.indexOf(column));
        this.availableListButtons();
    }

    public void addSelection() {
        int idx = this.availableList.getSelectionIndex();
        this.addColumn(this.availableList.getItem(idx));
    }

    public void removeSelection() {
        int idx = this.showList.getSelectionIndex();
        this.removeColumn(this.showList.getItem(idx));
    }

    public void addColumn(String column) {
        if (this.addButton.isEnabled()) {
            this.availableList.remove(column);
            this.showList.add(column);
            this.showList.setSelection(this.showList.getItemCount() - 1);
            this.showList.setFocus();
            this.showListButtons();
        }
    }

    public void removeColumn(String column) {
        if (this.removeButton.isEnabled()) {
            this.showList.remove(column);
            this.availableList.add(column);
            this.availableList.setSelection(this.availableList.getItemCount() - 1);
            this.availableList.setFocus();
            this.availableListButtons();
        }
    }

    public String[] getAvailableList() {
        return this.availableList.getItems();
    }

    public String[] getShowList() {
        return this.showList.getItems();
    }
}

