/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.dialogs.PerforceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FileTypeDialog
extends PerforceDialog {
    private Button textType;
    private Button binaryType;
    private Button symlinkType;
    private Button resourceType;
    private Button appleType;
    private Button unicodeType;
    private Button execModifier;
    private Button writeableModifier;
    private Button keywordModifier;
    private Button onlyModifier;
    private Button preserveModifier;
    private Button multipleModifier;
    private Button defaultStorage;
    private Button compressedStorage;
    private Button deltaStorage;
    private Button fullStorage;
    private Button singleStorage;
    private String fileType;

    public FileTypeDialog(Shell parent, String fileType) {
        super(parent, Messages.FileTypeDialog_ChangeFileType);
        this.fileType = fileType;
    }

    public String getFileType() {
        return this.fileType;
    }

    protected void okPressed() {
        this.fileType = this.getSelectedFileType();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = this.createComposite(dialogArea, 1);
        this.createTypeGroup(composite);
        this.createModifiersGroup(composite);
        this.createStorageGroup(composite);
        if (this.fileType.indexOf(43) == -1) {
            this.setOldTypeSwitches(this.fileType);
        } else {
            this.setNewTypeSwitches(this.fileType);
        }
        return dialogArea;
    }

    private void createTypeGroup(Composite parent) {
        Group group = this.createGroup(parent, Messages.FileTypeDialog_BaseFileType, 6);
        this.textType = this.createRadio((Composite)group, Messages.FileTypeDialog_Text);
        this.binaryType = this.createRadio((Composite)group, Messages.FileTypeDialog_Binary);
        this.symlinkType = this.createRadio((Composite)group, Messages.FileTypeDialog_Symlink);
        this.unicodeType = this.createRadio((Composite)group, Messages.FileTypeDialog_Unicode);
        this.resourceType = this.createRadio((Composite)group, Messages.FileTypeDialog_Resource);
        this.appleType = this.createRadio((Composite)group, Messages.FileTypeDialog_Apple);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.textType, "com.perforce.team.ui.file_type_text");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.binaryType, "com.perforce.team.ui.file_type_binary");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.symlinkType, "com.perforce.team.ui.file_type_symlink");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.unicodeType, "com.perforce.team.ui.file_type_unicode");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.resourceType, "com.perforce.team.ui.file_type_resource");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.appleType, "com.perforce.team.ui.file_type_apple");
    }

    private void createModifiersGroup(Composite parent) {
        Group group = this.createGroup(parent, Messages.FileTypeDialog_FileTypeModifiers, 4);
        this.execModifier = this.createCheck((Composite)group, "+x");
        this.createMarginLabel((Composite)group, Messages.FileTypeDialog_ExecBitSetOnClient, 3);
        this.writeableModifier = this.createCheck((Composite)group, "+w");
        this.createMarginLabel((Composite)group, Messages.FileTypeDialog_AlwaysWritableOnClient, 3);
        this.keywordModifier = this.createCheck((Composite)group, "+k");
        this.keywordModifier.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!FileTypeDialog.this.keywordModifier.getSelection()) {
                    FileTypeDialog.this.onlyModifier.setSelection(false);
                }
            }
        });
        this.createMarginLabel((Composite)group, Messages.FileTypeDialog_KeywordExpansion, 1);
        this.onlyModifier = this.createCheck((Composite)group, "+o");
        ((GridData)this.onlyModifier.getLayoutData()).horizontalIndent = 10;
        this.onlyModifier.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FileTypeDialog.this.onlyModifier.getSelection()) {
                    FileTypeDialog.this.keywordModifier.setSelection(true);
                }
            }
        });
        this.createMarginLabel((Composite)group, Messages.FileTypeDialog_OnlyIdAndHeader, 1);
        this.preserveModifier = this.createCheck((Composite)group, "+m");
        this.createMarginLabel((Composite)group, Messages.FileTypeDialog_PreserveModeTimes, 3);
        this.multipleModifier = this.createCheck((Composite)group, "+l");
        this.createMarginLabel((Composite)group, Messages.FileTypeDialog_DisallowMultipleOpens, 3);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.execModifier, "com.perforce.team.ui.file_type_exec");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.writeableModifier, "com.perforce.team.ui.file_type_writeable");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.keywordModifier, "com.perforce.team.ui.file_type_keyword");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.preserveModifier, "com.perforce.team.ui.file_type_preserve");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.multipleModifier, "com.perforce.team.ui.file_type_multiple");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.onlyModifier, "com.perforce.team.ui.file_type_only");
    }

    private void createStorageGroup(Composite parent) {
        Group group = this.createGroup(parent, Messages.FileTypeDialog_ServerStorageMethod, 2);
        this.defaultStorage = this.createRadio((Composite)group, Messages.FileTypeDialog_ServerStoresDefaultMethod);
        ((GridData)this.defaultStorage.getLayoutData()).horizontalSpan = 2;
        this.compressedStorage = this.createRadio((Composite)group, "+C");
        this.createMarginLabel((Composite)group, Messages.FileTypeDialog_ServerStoresCompressedRevs, 1);
        this.deltaStorage = this.createRadio((Composite)group, "+D");
        this.createMarginLabel((Composite)group, Messages.FileTypeDialog_ServerStoresRCSDeltas, 1);
        this.fullStorage = this.createRadio((Composite)group, "+F");
        this.createMarginLabel((Composite)group, Messages.FileTypeDialog_ServerStoresFullRevs, 1);
        this.singleStorage = this.createRadio((Composite)group, "+S");
        this.createMarginLabel((Composite)group, Messages.FileTypeDialog_ServerStoresOnlyHeadRev, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.defaultStorage, "com.perforce.team.ui.file_type_default");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.compressedStorage, "com.perforce.team.ui.file_type_compressed");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.deltaStorage, "com.perforce.team.ui.file_type_delta");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fullStorage, "com.perforce.team.ui.file_type_full");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.singleStorage, "com.perforce.team.ui.file_type_single");
    }

    private void setNewTypeSwitches(String type) {
        int idx = type.indexOf(43);
        String baseType = type.substring(0, idx);
        String modifiers = type.substring(idx + 1);
        if (baseType.equals("text")) {
            this.textType.setSelection(true);
        } else if (baseType.equals("binary")) {
            this.binaryType.setSelection(true);
        } else if (baseType.equals("symlink")) {
            this.symlinkType.setSelection(true);
        } else if (baseType.equals("resource")) {
            this.resourceType.setSelection(true);
        } else if (baseType.equals("apple")) {
            this.appleType.setSelection(true);
        } else {
            this.unicodeType.setSelection(true);
        }
        if (modifiers.indexOf(67) != -1) {
            this.compressedStorage.setSelection(true);
        } else if (modifiers.indexOf(68) != -1) {
            this.deltaStorage.setSelection(true);
        } else if (modifiers.indexOf(70) != -1) {
            this.fullStorage.setSelection(true);
        } else if (modifiers.indexOf(83) != -1) {
            this.singleStorage.setSelection(true);
        } else {
            this.defaultStorage.setSelection(true);
        }
        if (modifiers.indexOf(120) != -1) {
            this.execModifier.setSelection(true);
        }
        if (modifiers.indexOf(119) != -1) {
            this.writeableModifier.setSelection(true);
        }
        if (modifiers.indexOf(107) != -1) {
            this.keywordModifier.setSelection(true);
        }
        if (modifiers.indexOf(111) != -1) {
            this.onlyModifier.setSelection(true);
        }
        if (modifiers.indexOf(109) != -1) {
            this.preserveModifier.setSelection(true);
        }
        if (modifiers.indexOf(108) != -1) {
            this.multipleModifier.setSelection(true);
        }
    }

    private void setOldTypeSwitches(String type) {
        if (type.equals("text") || type.equals("")) {
            this.textType.setSelection(true);
            this.defaultStorage.setSelection(true);
        } else if (type.equals("binary")) {
            this.binaryType.setSelection(true);
            this.defaultStorage.setSelection(true);
        } else if (type.equals("symlink")) {
            this.symlinkType.setSelection(true);
            this.defaultStorage.setSelection(true);
        } else if (type.equals("resource")) {
            this.resourceType.setSelection(true);
            this.defaultStorage.setSelection(true);
        } else if (type.equals("apple")) {
            this.appleType.setSelection(true);
            this.defaultStorage.setSelection(true);
        } else if (type.equals("unicode")) {
            this.unicodeType.setSelection(true);
            this.defaultStorage.setSelection(true);
        } else if (type.equals("ctext")) {
            this.textType.setSelection(true);
            this.compressedStorage.setSelection(true);
        } else if (type.equals("cxtext")) {
            this.textType.setSelection(true);
            this.execModifier.setSelection(true);
            this.compressedStorage.setSelection(true);
        } else if (type.equals("ktext")) {
            this.textType.setSelection(true);
            this.keywordModifier.setSelection(true);
            this.defaultStorage.setSelection(true);
        } else if (type.equals("kxtext")) {
            this.textType.setSelection(true);
            this.keywordModifier.setSelection(true);
            this.execModifier.setSelection(true);
            this.defaultStorage.setSelection(true);
        } else if (type.equals("ltext")) {
            this.textType.setSelection(true);
            this.fullStorage.setSelection(true);
        } else if (type.equals("tempobj")) {
            this.binaryType.setSelection(true);
            this.writeableModifier.setSelection(true);
            this.singleStorage.setSelection(true);
        } else if (type.equals("ubinary")) {
            this.binaryType.setSelection(true);
            this.fullStorage.setSelection(true);
        } else if (type.equals("uresource")) {
            this.resourceType.setSelection(true);
            this.fullStorage.setSelection(true);
        } else if (type.equals("uxbinary")) {
            this.binaryType.setSelection(true);
            this.execModifier.setSelection(true);
            this.fullStorage.setSelection(true);
        } else if (type.equals("xbinary")) {
            this.binaryType.setSelection(true);
            this.execModifier.setSelection(true);
            this.defaultStorage.setSelection(true);
        } else if (type.equals("xltext")) {
            this.textType.setSelection(true);
            this.execModifier.setSelection(true);
            this.fullStorage.setSelection(true);
        } else if (type.equals("xtempobj")) {
            this.binaryType.setSelection(true);
            this.writeableModifier.setSelection(true);
            this.execModifier.setSelection(true);
            this.singleStorage.setSelection(true);
        } else if (type.equals("xtext")) {
            this.textType.setSelection(true);
            this.execModifier.setSelection(true);
            this.defaultStorage.setSelection(true);
        } else if (type.equals("xunicode")) {
            this.unicodeType.setSelection(true);
            this.execModifier.setSelection(true);
            this.defaultStorage.setSelection(true);
        }
    }

    public String getSelectedFileType() {
        String type = null;
        type = this.textType.getSelection() ? "text" : (this.binaryType.getSelection() ? "binary" : (this.symlinkType.getSelection() ? "symlink" : (this.resourceType.getSelection() ? "resource" : (this.appleType.getSelection() ? "apple" : "unicode"))));
        String typeModifiers = "";
        if (this.compressedStorage.getSelection()) {
            typeModifiers = String.valueOf(typeModifiers) + "C";
        } else if (this.deltaStorage.getSelection()) {
            typeModifiers = String.valueOf(typeModifiers) + "D";
        } else if (this.fullStorage.getSelection()) {
            typeModifiers = String.valueOf(typeModifiers) + "F";
        } else if (this.singleStorage.getSelection()) {
            typeModifiers = String.valueOf(typeModifiers) + "S";
        }
        if (this.execModifier.getSelection()) {
            typeModifiers = String.valueOf(typeModifiers) + "x";
        }
        if (this.writeableModifier.getSelection()) {
            typeModifiers = String.valueOf(typeModifiers) + "w";
        }
        if (this.keywordModifier.getSelection()) {
            typeModifiers = String.valueOf(typeModifiers) + "k";
        }
        if (this.onlyModifier.getSelection()) {
            typeModifiers = String.valueOf(typeModifiers) + "o";
        }
        if (this.preserveModifier.getSelection()) {
            typeModifiers = String.valueOf(typeModifiers) + "m";
        }
        if (this.multipleModifier.getSelection()) {
            typeModifiers = String.valueOf(typeModifiers) + "l";
        }
        if (typeModifiers.length() > 0) {
            type = String.valueOf(type) + "+" + typeModifiers;
        }
        return type;
    }

    private void createMarginLabel(Composite parent, String title, int span) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        composite.setLayoutData((Object)gd);
        RowLayout row = new RowLayout();
        row.marginLeft = 0;
        row.marginRight = 0;
        row.marginTop = 0;
        row.marginBottom = 2;
        composite.setLayout((Layout)row);
        new Label(composite, 0).setText(title);
    }
}

