/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConfirmRevertDialog
extends P4StatusDialog {
    public static final String DELETE_EMPTIES = "com.perforce.team.ui.dialogs.DELETE_EMPTIES";
    public static final String DELETE_SHELVES = "com.perforce.team.ui.dialogs.DELETE_SHELVES";
    private Composite displayArea;
    private Label header;
    private Label countLabel;
    private CheckboxTableViewer fileViewer;
    private Button selectAll;
    private Button deselectAll;
    private Button deleteEmptyChangelists;
    private Button deleteShelvedFiles;
    private IP4File[] files = null;
    private IP4File[] selected;
    private boolean showDeleteEmpties = false;
    private boolean showDeleteShelves = false;
    private boolean deleteEmpties = false;
    private boolean deleteShelves = false;

    public static IP4File[] openQuestion(Shell shell, IP4File[] files) {
        ConfirmRevertDialog dialog = ConfirmRevertDialog.openQuestion(shell, files, true);
        int rc = dialog.open();
        if (rc == 0) {
            return dialog.getSelected();
        }
        return new IP4File[0];
    }

    public static ConfirmRevertDialog openQuestion(Shell shell, IP4File[] files, boolean block, boolean offerToDeleteEmpties) {
        ConfirmRevertDialog dialog = new ConfirmRevertDialog(shell, files, offerToDeleteEmpties);
        dialog.setBlockOnOpen(block);
        return dialog;
    }

    public static ConfirmRevertDialog openQuestion(Shell shell, IP4File[] files, boolean block) {
        return ConfirmRevertDialog.openQuestion(shell, files, block, false);
    }

    public boolean close() {
        Object[] checked = this.fileViewer.getCheckedElements();
        this.selected = new IP4File[checked.length];
        int i = 0;
        while (i < checked.length) {
            this.selected[i] = (IP4File)checked[i];
            ++i;
        }
        return super.close();
    }

    protected void okPressed() {
        if (this.deleteEmptyChangelists != null) {
            this.deleteEmpties = this.deleteEmptyChangelists.getSelection();
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(DELETE_EMPTIES, this.deleteEmpties);
        }
        if (this.deleteShelvedFiles != null) {
            this.deleteShelves = this.deleteShelvedFiles.getSelection();
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(DELETE_SHELVES, this.deleteShelves);
        }
        super.okPressed();
    }

    public boolean deleteEmptyChangelists() {
        return this.deleteEmpties;
    }

    public boolean deleteShelvedFiles() {
        return this.deleteShelves;
    }

    public ConfirmRevertDialog(Shell parent, IP4File[] files) {
        this(parent, files, false);
    }

    public ConfirmRevertDialog(Shell parent, IP4File[] files, boolean showDeleteEmpties) {
        super(parent);
        if (files != null) {
            this.files = files;
            if (this.files.length > 0) {
                this.showDeleteShelves = this.files[0].getConnection().isShelvingSupported();
            }
        } else {
            this.files = new IP4File[0];
        }
        this.setTitle(MessageFormat.format(Messages.ConfirmRevertDialog_RevertFiles, this.files.length));
        this.showDeleteEmpties = showDeleteEmpties;
        this.setModalResizeStyle();
    }

    public IP4File[] getSelected() {
        return this.selected;
    }

    private void updateCount() {
        int count = this.fileViewer.getCheckedElements().length;
        int max = this.fileViewer.getTable().getItemCount();
        this.countLabel.setText(MessageFormat.format(Messages.ConfirmRevertDialog_FilesSelected, count, max));
        if (count == 0) {
            this.setErrorMessage(Messages.ConfirmRevertDialog_MustSelectAtLeastOneFile, null);
        } else {
            this.setInfoMessage(MessageFormat.format(Messages.ConfirmRevertDialog_RevertingWillOverwrite, max));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogParent = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(dialogParent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.displayArea.setLayout((Layout)layout);
        GridData daData = new GridData(4, 4, true, true);
        this.displayArea.setLayoutData((Object)daData);
        this.header = new Label(this.displayArea, 16384);
        this.header.setText(MessageFormat.format(Messages.ConfirmRevertDialog_RevertSelected, this.files == null ? 0 : this.files.length));
        this.countLabel = new Label(this.displayArea, 16384);
        GridData clData = new GridData(4, 4, true, false);
        clData.verticalIndent = 5;
        this.countLabel.setLayoutData((Object)clData);
        this.fileViewer = CheckboxTableViewer.newCheckList((Composite)this.displayArea, (int)67588);
        this.fileViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fileViewer.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof IP4File) {
                    String path = ((IP4File)element).getActionPath(IP4Resource.Type.REMOTE);
                    String decorated = this.decorator.getLabelDecorator().decorateText(path, element);
                    if (decorated != null) {
                        path = decorated;
                    }
                    return path;
                }
                return super.getColumnText(element, columnIndex);
            }
        });
        this.fileViewer.setSorter(new ViewerSorter());
        if (this.files != null) {
            this.fileViewer.setInput((Object)this.files);
        }
        this.fileViewer.setAllChecked(true);
        this.updateCount();
        P4UIUtils.trackMovedFiles((ICheckable)this.fileViewer);
        this.fileViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ConfirmRevertDialog.this.updateCount();
            }
        });
        GridData fvData = new GridData(4, 4, true, true);
        fvData.heightHint = 100;
        fvData.widthHint = 400;
        this.fileViewer.getTable().setLayoutData((Object)fvData);
        Composite buttons = new Composite(this.displayArea, 0);
        GridLayout bLayout = new GridLayout(2, false);
        buttons.setLayout((Layout)bLayout);
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        this.selectAll = new Button(buttons, 8);
        this.selectAll.setText(Messages.ConfirmRevertDialog_SelectAll);
        this.selectAll.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfirmRevertDialog.this.fileViewer.setAllChecked(true);
                ConfirmRevertDialog.this.updateCount();
            }
        });
        this.deselectAll = new Button(buttons, 8);
        this.deselectAll.setText(Messages.ConfirmRevertDialog_DeselectAll);
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfirmRevertDialog.this.fileViewer.setAllChecked(false);
                ConfirmRevertDialog.this.updateCount();
            }
        });
        if (this.showDeleteEmpties) {
            if (this.showDeleteShelves) {
                this.deleteShelvedFiles = new Button(this.displayArea, 32);
                this.deleteShelvedFiles.setText(Messages.ConfirmRevertDialog_DeleteShelvedAfterRevert);
                this.deleteShelvedFiles.setSelection(PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(DELETE_SHELVES));
            }
            this.deleteEmptyChangelists = new Button(this.displayArea, 32);
            this.deleteEmptyChangelists.setText(Messages.ConfirmRevertDialog_DeleteEmptyPendingAfterRevert);
            this.deleteEmptyChangelists.setSelection(PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean(DELETE_EMPTIES));
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ConfirmRevertDialog.this.deleteShelvedFiles != null) {
                        ConfirmRevertDialog.this.deleteShelvedFiles.setEnabled(!ConfirmRevertDialog.this.deleteEmptyChangelists.getSelection());
                        if (ConfirmRevertDialog.this.deleteEmptyChangelists.getSelection()) {
                            ConfirmRevertDialog.this.deleteShelvedFiles.setSelection(true);
                        }
                    }
                }
            };
            this.deleteEmptyChangelists.addSelectionListener((SelectionListener)listener);
            listener.widgetSelected(null);
        }
        return dialogParent;
    }
}

