/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.p4java.core.IDepot;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.ui.PerforceUIPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.WorkbenchAdapter;

public class Folder
extends WorkbenchAdapter {
    private Folder parent;
    private String path;
    private String name = "";
    protected IP4Connection connection = null;
    protected List<Object> children = new ArrayList<Object>();
    protected Type type;
    protected int folderCount = 0;
    protected int childCount = 0;

    public static Folder[] buildTree(Object[] files, Type type) {
        FolderBuilder builder = new FolderBuilder(files, type);
        return builder.build();
    }

    public void setConnection(IP4Connection connection) {
        this.connection = connection;
    }

    public static void compressFolders(Folder[] folders) {
        if (folders != null) {
            Folder[] folderArray = folders;
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                Folder folder = folderArray[n2];
                folder.compress();
                ++n2;
            }
        }
    }

    public static void compressFolders(Folder folder) {
        if (folder == null) {
            return;
        }
        folder.compress();
    }

    public Folder(Folder parent, String path, Type type) {
        this.parent = parent;
        this.path = path;
        if (this.path == null) {
            this.path = "";
        }
        this.type = type;
        this.name = this.generateName();
    }

    public boolean canCompress() {
        return this.folderCount == 0 || this.folderCount == 1 && this.childCount == 0;
    }

    public boolean containsFolders() {
        return this.children.size() > this.childCount;
    }

    public boolean containsFiles() {
        return this.childCount > 0;
    }

    private String generateName() {
        if (this.type == Type.TREE) {
            int lastSlash = this.path.lastIndexOf(47);
            if (lastSlash + 1 < this.path.length()) {
                if (lastSlash > 1) {
                    return this.path.substring(lastSlash + 1);
                }
                return this.path;
            }
        } else if (this.type == Type.COMPRESSED && this.parent != null && this.path.length() > this.parent.path.length() + 1) {
            return this.path.substring(this.parent.path.length() + 1);
        }
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Folder) {
            Folder folder = (Folder)((Object)obj);
            if (this.path.equals(folder.path)) {
                return this.parent != null ? this.parent.equals((Object)folder.parent) : true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path != null) {
            this.path = path;
            this.name = this.generateName();
        }
    }

    public void add(Object child) {
        if (child != null) {
            if (!(child instanceof Folder)) {
                ++this.childCount;
            } else {
                ++this.folderCount;
                ((Folder)((Object)child)).parent = this;
            }
            this.children.add(child);
        }
    }

    public void remove(Object child) {
        if (child != null && this.children.remove(child)) {
            if (child instanceof Folder) {
                --this.folderCount;
            } else {
                --this.childCount;
            }
        }
    }

    public Object[] getChildren(Object o) {
        return this.children.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (this.isDepot()) {
            IDepot.DepotType type;
            P4Depot depot;
            ImageDescriptor depotIcon = null;
            if (this.connection != null && (depot = this.connection.getDepot(this.getLabel((Object)this))) != null && (type = depot.getType()) != null) {
                switch (type) {
                    case REMOTE: {
                        depotIcon = PerforceUIPlugin.getDescriptor("perforce/depot_remote.png");
                        break;
                    }
                    case SPEC: {
                        depotIcon = PerforceUIPlugin.getDescriptor("perforce/depot_spec.png");
                        break;
                    }
                }
            }
            if (depotIcon == null) {
                depotIcon = PerforceUIPlugin.getDescriptor("perforce/depot.png");
            }
            return depotIcon;
        }
        return PerforceUIPlugin.getDescriptor("perforce/depot_folder.png");
    }

    private boolean isDepot() {
        boolean depot = false;
        if (this.getParent((Object)this) == null) {
            if (this.type == Type.TREE) {
                depot = true;
            } else if (this.type == Type.COMPRESSED) {
                depot = this.path.lastIndexOf(47) == 1;
            }
        }
        return depot;
    }

    public String getLabel(Object o) {
        if (this.isDepot() && this.name.startsWith("//")) {
            return this.name.substring(2);
        }
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void compress() {
        int n;
        if (this.canCompress()) {
            Object[] children;
            Object[] objectArray = children = this.getChildren((Object)this);
            int n2 = children.length;
            n = 0;
            while (n < n2) {
                Object child = objectArray[n];
                if (child instanceof Folder) {
                    Folder subFolder = (Folder)((Object)child);
                    this.remove((Object)subFolder);
                    this.setPath(subFolder.getPath());
                    Object[] objectArray2 = subFolder.getChildren((Object)subFolder);
                    int n3 = objectArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object fChild = objectArray2[n4];
                        this.add(fChild);
                        ++n4;
                    }
                    this.compress();
                    break;
                }
                ++n;
            }
        }
        Object[] objectArray = this.getChildren((Object)this);
        n = objectArray.length;
        int n5 = 0;
        while (n5 < n) {
            Object child = objectArray[n5];
            if (child instanceof Folder) {
                ((Folder)((Object)child)).compress();
            }
            ++n5;
        }
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public static class FolderBuilder {
        private Object[] files;
        private Type type;

        public FolderBuilder(Object[] files, Type type) {
            this.files = files;
            this.type = type;
        }

        protected Folder createFolder(Folder parent, String path, Type type) {
            return new Folder(parent, path, type);
        }

        private Folder getTreeParent(String path, Map<String, Folder> folders, Map<String, Folder> roots, Type type) {
            Folder folder = null;
            if (path.lastIndexOf(47) != 1) {
                String parentPath = path.substring(0, path.lastIndexOf(47));
                Folder parent = null;
                if (folders.containsKey(parentPath)) {
                    parent = folders.get(parentPath);
                } else {
                    parent = this.getTreeParent(parentPath, folders, roots, type);
                    folders.put(parentPath, parent);
                }
                folder = this.createFolder(parent, path, type);
                parent.add((Object)folder);
            } else {
                folder = this.createFolder(null, path, type);
                roots.put(path, folder);
            }
            return folder;
        }

        public Folder[] build() {
            return this.build(false);
        }

        public Folder[] build(boolean compress) {
            HashMap<String, Folder> roots = new HashMap<String, Folder>();
            HashMap<String, Folder> folders = new HashMap<String, Folder>();
            IP4Connection connection = null;
            Object[] objectArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                IP4Resource file = (IP4Resource)P4CoreUtils.convert((Object)element, IP4Resource.class);
                if (file != null) {
                    String path;
                    if (connection == null) {
                        connection = file.getConnection();
                    }
                    if ((path = file.getRemotePath()) != null) {
                        String parentPath = path.substring(0, path.lastIndexOf(47));
                        Folder parent = null;
                        if (folders.containsKey(parentPath)) {
                            parent = (Folder)((Object)folders.get(parentPath));
                        } else {
                            parent = this.getTreeParent(parentPath, folders, roots, this.type);
                            folders.put(parentPath, parent);
                        }
                        parent.add(element);
                    }
                }
                ++n2;
            }
            Folder[] treeFolders = roots.values().toArray(new Folder[roots.size()]);
            if (connection != null) {
                Folder[] folderArray = treeFolders;
                int n3 = treeFolders.length;
                n = 0;
                while (n < n3) {
                    Folder folder = folderArray[n];
                    folder.setConnection(connection);
                    ++n;
                }
            }
            if (compress) {
                Folder.compressFolders(treeFolders);
            }
            return treeFolders;
        }
    }

    public static enum Type {
        FLAT,
        TREE,
        COMPRESSED;

    }
}

