/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.views.SessionManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DescriptionTemplate
implements IWorkbenchAdapter,
IAdaptable {
    private String content = null;
    private String formatted = null;

    public static List<DescriptionTemplate> getTemplates() {
        ArrayList<DescriptionTemplate> templates = new ArrayList<DescriptionTemplate>();
        String[] stringArray = SessionManager.getEntries("com.perforce.team.ui.preferences.CHANGELIST_TEMPLATES", false);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String content = stringArray[n2];
            templates.add(new DescriptionTemplate(content));
            ++n2;
        }
        return templates;
    }

    public static List<DescriptionTemplate> getHistory() {
        ArrayList<DescriptionTemplate> templates = new ArrayList<DescriptionTemplate>();
        String[] stringArray = SessionManager.getEntries("com.perforce.team.ui.preferences.CHANGELIST_DESCRIPTIONS", false);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String content = stringArray[n2];
            templates.add(new DescriptionTemplate(content));
            ++n2;
        }
        return templates;
    }

    public static void saveHistory(String latest) {
        if (latest != null) {
            String[] templates;
            boolean shouldAdd = true;
            String[] stringArray = templates = SessionManager.getEntries("com.perforce.team.ui.preferences.CHANGELIST_TEMPLATES", false);
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                if (latest.equals(entry)) {
                    shouldAdd = false;
                    break;
                }
                ++n2;
            }
            if (shouldAdd) {
                String[] current = SessionManager.getEntries("com.perforce.team.ui.preferences.CHANGELIST_DESCRIPTIONS", false);
                int max = PerforceUIPlugin.getPlugin().getPreferenceStore().getInt("com.perforce.team.ui.preferences.CHANGELISTS_SAVED");
                int count = Math.min(max, current.length + 1);
                ArrayList<String> entries = new ArrayList<String>();
                entries.add(latest);
                int index = 0;
                while (index < current.length && entries.size() < count) {
                    String entry = current[index];
                    if (!entries.contains(entry)) {
                        entries.add(entry);
                    }
                    ++index;
                }
                SessionManager.saveHistory(entries, "com.perforce.team.ui.preferences.CHANGELIST_DESCRIPTIONS");
            }
        }
    }

    public static void saveTemplates(List<DescriptionTemplate> templates) {
        if (templates != null) {
            ArrayList<String> entries = new ArrayList<String>();
            for (DescriptionTemplate tpl : templates) {
                String content = tpl.getContent();
                if (content == null) continue;
                entries.add(content);
            }
            SessionManager.saveEntries(entries, "com.perforce.team.ui.preferences.CHANGELIST_TEMPLATES");
        }
    }

    public DescriptionTemplate(String content) {
        this.content = content;
        this.format();
    }

    private void format() {
        this.formatted = this.content != null ? this.content.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t") : "";
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.format();
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.formatted;
    }

    public Object getParent(Object o) {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IWorkbenchAdapter.class == adapter) {
            return this;
        }
        return null;
    }
}

