/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.branches;

import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.branches.BaseBranchDialog;
import com.perforce.team.ui.branches.BranchWidget;
import com.perforce.team.ui.branches.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class NewBranchDialog
extends BaseBranchDialog {
    private IP4Connection connection;
    private IP4Branch template;
    private IP4Branch createdBranch;

    public NewBranchDialog(Shell parent, IP4Connection connection, IP4Branch template) {
        super(parent);
        if (connection != null) {
            ConnectionParameters params = connection.getParameters();
            this.setTitle(NLS.bind((String)Messages.NewBranchDialog_Title, (Object)params.getPort(), (Object)params.getUser()));
        }
        this.connection = connection;
        this.template = template;
    }

    @Override
    protected void fillWidget(BranchWidget widget) {
        widget.setEditable(true);
        widget.setDatesVisible(false);
        widget.update(this.template);
        widget.setBranchName("");
    }

    public IP4Branch getCreatedBranch() {
        return this.createdBranch;
    }

    private boolean branchExists(IP4Connection connection, String name) {
        boolean exists = false;
        IP4Branch branch = connection.getBranch(name);
        if (branch != null) {
            exists = branch.getUpdateTime() != null && branch.getAccessTime() != null;
        }
        return exists;
    }

    @Override
    public boolean save() {
        boolean retry = true;
        while (retry) {
            retry = false;
            try {
                IBranchSpec latest = this.getLatestSpec();
                if (!this.branchExists(this.connection, latest.getName())) {
                    this.createdBranch = this.connection.createBranch(latest);
                    continue;
                }
                P4ConnectionManager.getManager().openInformation(P4UIUtils.getDialogShell(), NLS.bind((String)Messages.NewBranchDialog_BranchExistsTitle, (Object)latest.getName()), NLS.bind((String)Messages.NewBranchDialog_BranchExistsMessage, (Object)latest.getName()));
                return false;
            }
            catch (P4JavaException e) {
                retry = P4ConnectionManager.getManager().displayException(this.connection, e, true, true);
                if (retry) continue;
                return false;
            }
        }
        return true;
    }
}

