/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.branches;

import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.branches.Messages;
import com.perforce.team.ui.branches.NewBranchDialog;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.runtime.IProgressMonitor;

public class NewBranchAction
extends P4Action {
    private IP4Branch createdBranch = null;

    public IP4Branch getCreatedBranch() {
        return this.createdBranch;
    }

    @Override
    protected void runAction() {
        final IP4Connection connection = this.getSingleOnlineConnectionSelection();
        if (connection != null) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.NewBranchAction_CreateNewBranch, 3);
                    monitor.setTaskName(Messages.NewBranchAction_GeneratingBranchTemplate);
                    final IP4Branch branch = connection.getBranch("x_new_spec_name_x");
                    monitor.worked(1);
                    monitor.setTaskName(Messages.NewBranchAction_DisplayingNewBranchDialog);
                    final IP4Branch[] created = new IP4Branch[1];
                    PerforceUIPlugin.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            NewBranchDialog dialog = new NewBranchDialog(P4UIUtils.getDialogShell(), connection, branch);
                            if (dialog.open() == 0) {
                                created[0] = dialog.getCreatedBranch();
                            }
                        }
                    });
                    monitor.worked(1);
                    if (created[0] != null) {
                        monitor.setTaskName(Messages.NewBranchAction_RefreshingNewBranch);
                        NewBranchAction.this.sendCreateEvent(created[0]);
                    }
                    monitor.worked(1);
                    monitor.done();
                }

                public String getTitle() {
                    return Messages.NewBranchAction_RetrievingBranchTemplate;
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    private void sendCreateEvent(IP4Branch branch) {
        IP4Branch created = branch.getConnection().getBranch(branch.getName());
        if (created != null) {
            this.createdBranch = created;
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.CREATE_BRANCH, (IP4Resource)created));
        }
    }
}

