/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.branches;

import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.branches.BaseBranchDialog;
import com.perforce.team.ui.branches.BranchWidget;
import com.perforce.team.ui.branches.Messages;
import com.perforce.team.ui.dialogs.P4FormDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class EditBranchDialog
extends BaseBranchDialog {
    private IP4Branch branch;
    private IBranchSpec updatedBranch;
    private boolean canEdit = true;

    public EditBranchDialog(Shell parent, IP4Branch branch) {
        super(parent);
        this.setType(P4FormDialog.Type.EDIT);
        this.branch = branch;
        if (branch != null) {
            this.setTitle(NLS.bind((String)Messages.EditBranchDialog_EditBranch, (Object)branch.getName()));
            String user = this.branch.getConnection().getParameters().getUserNoNull();
            String owner = branch.getOwner();
            if (this.branch.isLocked() && owner != null && !"".equals(owner) && !user.equals(owner)) {
                this.canEdit = false;
            }
        }
    }

    @Override
    protected void fillWidget(BranchWidget widget) {
        widget.setEditable(this.canEdit);
        widget.setBranchNameEditable(false);
        widget.setDatesEditable(false);
        widget.update(this.branch);
    }

    public void create() {
        super.create();
        if (!this.canEdit) {
            this.setErrorMessage(Messages.EditBranchDialog_BranchIsLocked);
        }
    }

    private void updateBranch() {
        this.updatedBranch = this.getLatestSpec();
    }

    @Override
    public boolean save() {
        this.updateBranch();
        boolean retry = true;
        while (retry) {
            retry = false;
            try {
                this.branch.update(this.updatedBranch);
            }
            catch (P4JavaException e) {
                retry = P4ConnectionManager.getManager().displayException(this.branch.getConnection(), e, true, true);
                if (retry) continue;
                return false;
            }
        }
        return true;
    }
}

