/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.search;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.BaseErrorProvider;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mylyn.search.FilterEntry;
import com.perforce.team.ui.mylyn.search.IFilterListener;
import com.perforce.team.ui.mylyn.search.Messages;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class FilterManager
extends BaseErrorProvider {
    public static final int DEFAULT_FIELDS = 3;
    public static final String FILTER_FIELD = "filter";
    public static final String OPERATOR_FIELD = "operator";
    public static final String ENTRY_FIELD = "entry";
    public static final String NAME_FIELD = "name";
    public static final String VALUE_FIELD = "value";
    public static final String WORDS_FIELD = "words";
    public static final String WORDS_TYPE_FIELD = "wordsType";
    public static final String ALL_TYPE = "all";
    public static final String ANY_TYPE = "any";
    private IJobSpec spec;
    private ScrolledComposite scrolls;
    private Composite displayArea;
    private Text wordsText;
    private Combo wordsMatchCombo;
    private List<FilterEntry> filters = new ArrayList<FilterEntry>();
    private ListenerList listeners = new ListenerList();
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            FilterEntry entry = (FilterEntry)event.data;
            Object[] objectArray = FilterManager.this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IFilterListener)listener).modified(entry);
                ++n2;
            }
            FilterManager.this.checkQuery();
        }
    };

    private String getWords() {
        return this.wordsText.getText().trim();
    }

    private void checkQuery() {
        boolean querySpecified = this.getWords().length() > 0;
        boolean positiveMatch = querySpecified;
        if (!positiveMatch) {
            for (FilterEntry entry : this.filters) {
                FilterEntry.Filter filter = entry.getFilter();
                if (filter == null || filter.fullQuery == null) continue;
                querySpecified = true;
                if (filter.negated) continue;
                positiveMatch = true;
                break;
            }
        }
        this.errorMessage = querySpecified && !positiveMatch ? Messages.FilterManager_NoPositiveRule : null;
        this.validate();
    }

    public void setEnabled(boolean enabled) {
        this.displayArea.setEnabled(enabled);
    }

    public void loadDefaults() {
        int i = 0;
        while (i < 3) {
            FilterEntry entry = new FilterEntry(this, this.spec);
            entry.createControl(this.displayArea);
            this.add(entry);
            ++i;
        }
    }

    public void createControl(Composite parent, IP4Connection connection) {
        this.scrolls = new ScrolledComposite(parent, 2816);
        this.scrolls.setExpandHorizontal(true);
        this.scrolls.setExpandVertical(true);
        this.displayArea = new Composite((Composite)this.scrolls, 0);
        this.scrolls.setContent((Control)this.displayArea);
        GridData sData = new GridData(4, 4, true, true);
        sData.heightHint = 150;
        this.scrolls.setLayoutData((Object)sData);
        this.displayArea.setLayout((Layout)new GridLayout(1, false));
        GridData baData = new GridData(4, 4, true, true);
        baData.horizontalIndent = 15;
        this.displayArea.setLayoutData((Object)baData);
        Composite wordsArea = new Composite(this.displayArea, 0);
        GridLayout waLayout = new GridLayout(5, false);
        waLayout.marginHeight = 0;
        waLayout.marginWidth = 0;
        wordsArea.setLayout((Layout)waLayout);
        wordsArea.setLayoutData((Object)new GridData(4, 4, true, false));
        ModifyListener wordsListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = FilterManager.this.getWords();
                Object[] objectArray = FilterManager.this.listeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IFilterListener)listener).wordsModified(text);
                    ++n2;
                }
                FilterManager.this.checkQuery();
            }
        };
        Label wordsLabel = new Label(wordsArea, 0);
        wordsLabel.setText(Messages.FilterManager_Containing);
        this.wordsMatchCombo = new Combo(wordsArea, 12);
        this.wordsMatchCombo.add(Messages.FilterManager_all);
        this.wordsMatchCombo.add(Messages.FilterManager_any);
        this.wordsMatchCombo.select(0);
        this.wordsMatchCombo.addModifyListener(wordsListener);
        Label wordsSuffixLabel = new Label(wordsArea, 0);
        wordsSuffixLabel.setText(Messages.FilterManager_FollowingWords);
        this.wordsText = new Text(wordsArea, 2052);
        this.wordsText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.wordsText.addModifyListener(wordsListener);
        ToolBar wordBar = new ToolBar(wordsArea, 64);
        ToolItem clearWordsItem = new ToolItem(wordBar, 8);
        Image clearImage = PerforceUIPlugin.getDescriptor((String)"normal/clear.png").createImage();
        P4UIUtils.registerDisposal((Widget)clearWordsItem, (Resource)clearImage);
        clearWordsItem.setImage(clearImage);
        clearWordsItem.setToolTipText(Messages.FilterManager_ClearWords);
        clearWordsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterManager.this.wordsText.setText("");
            }
        });
        Label rulesLabel = new Label(this.displayArea, 0);
        rulesLabel.setText(Messages.FilterManager_MatchingConditions);
        this.spec = connection.getJobSpec();
    }

    public String getQuery() {
        StringBuilder fullQuery = new StringBuilder();
        TreeMap ors = new TreeMap();
        for (FilterEntry entry : this.filters) {
            FilterEntry.Filter filter = entry.getFilter();
            if (filter == null || filter.fullQuery == null) continue;
            if (!filter.negated && !"date".equals(filter.dateType)) {
                List<Object> filters = null;
                if (ors.containsKey(filter.name)) {
                    filters = (List)ors.get(filter.name);
                } else {
                    filters = new ArrayList();
                    ors.put(filter.name, filters);
                }
                filters.add(filter);
                continue;
            }
            if (fullQuery.length() > 0) {
                fullQuery.append(' ');
            }
            fullQuery.append(filter.fullQuery);
        }
        StringBuilder orsQuery = new StringBuilder();
        for (List filters : ors.values()) {
            if (orsQuery.length() > 0) {
                orsQuery.append(' ');
            }
            if (filters.size() > 1) {
                orsQuery.append('(');
                orsQuery.append(((FilterEntry.Filter)filters.get((int)0)).fullQuery);
                int i = 1;
                while (i < filters.size()) {
                    orsQuery.append('|');
                    orsQuery.append(((FilterEntry.Filter)filters.get((int)i)).fullQuery);
                    ++i;
                }
                orsQuery.append(')');
                continue;
            }
            orsQuery.append(((FilterEntry.Filter)filters.get((int)0)).fullQuery);
        }
        if (fullQuery.length() > 0) {
            fullQuery.insert(0, ' ');
        }
        fullQuery.insert(0, orsQuery);
        String words = this.getWords();
        if (words.length() > 0) {
            String separator = this.wordsMatchCombo.getSelectionIndex() == 0 ? " " : " | ";
            StringBuilder wordsSection = new StringBuilder();
            boolean multiple = false;
            String[] stringArray = words.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word.length() > 0) {
                    if (wordsSection.length() > 0) {
                        wordsSection.append(separator);
                        multiple = true;
                    }
                    wordsSection.append(FilterEntry.escapeValue(word.trim()));
                }
                ++n2;
            }
            if (wordsSection.length() > 0) {
                if (fullQuery.length() > 0) {
                    fullQuery.insert(0, ' ');
                }
                if (multiple) {
                    wordsSection.insert(0, '(');
                    wordsSection.append(')');
                }
                fullQuery.insert(0, wordsSection);
            }
        }
        return fullQuery.toString();
    }

    public String toStorageString() {
        StringWriter writer = new StringWriter();
        XMLMemento memento = XMLMemento.createWriteRoot((String)FILTER_FIELD);
        for (FilterEntry entry : this.filters) {
            FilterEntry.Filter filter = entry.getFilter();
            if (filter == null) continue;
            IMemento child = memento.createChild(ENTRY_FIELD);
            child.putString(NAME_FIELD, filter.name);
            child.putString(OPERATOR_FIELD, filter.operator);
            child.putString(VALUE_FIELD, filter.rawValue);
        }
        memento.putString(WORDS_FIELD, this.getWords());
        if (this.wordsMatchCombo.getSelectionIndex() == 0) {
            memento.putString(WORDS_TYPE_FIELD, ALL_TYPE);
        } else {
            memento.putString(WORDS_TYPE_FIELD, ANY_TYPE);
        }
        try {
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        return writer.toString();
    }

    public void fromStorageString(String storageString) {
        if (storageString != null) {
            try {
                String wordsType;
                String words;
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(storageString));
                IMemento[] iMementoArray = memento.getChildren(ENTRY_FIELD);
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento child = iMementoArray[n2];
                    String name = child.getString(NAME_FIELD);
                    String operator = child.getString(OPERATOR_FIELD);
                    String value = child.getString(VALUE_FIELD);
                    if (name != null && operator != null && value != null) {
                        FilterEntry filter = new FilterEntry(this, this.spec);
                        filter.createControl(this.displayArea);
                        filter.setName(name);
                        filter.setOperator(operator);
                        filter.setValue(value);
                        this.add(filter);
                    }
                    ++n2;
                }
                if (this.filters.size() < 3) {
                    int i = this.filters.size();
                    while (i < 3) {
                        FilterEntry entry = new FilterEntry(this, this.spec);
                        entry.createControl(this.displayArea);
                        this.add(entry);
                        ++i;
                    }
                }
                if ((words = memento.getString(WORDS_FIELD)) != null && words.length() > 0) {
                    this.wordsText.setText(words);
                }
                if (ANY_TYPE.equals(wordsType = memento.getString(WORDS_TYPE_FIELD))) {
                    this.wordsMatchCombo.select(1);
                }
            }
            catch (WorkbenchException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }

    public void add(FilterEntry entry) {
        if (entry != null) {
            if (this.filters.size() == 1) {
                this.filters.get(0).setRemoveEnabled(true);
            }
            this.filters.add(entry);
            entry.addListener(this.listener);
            entry.setRemoveEnabled(this.filters.size() > 1);
            this.scrolls.setMinSize(this.displayArea.computeSize(-1, -1));
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IFilterListener)listener).added(entry);
                ++n2;
            }
        }
    }

    public void remove(FilterEntry entry) {
        if (entry != null && this.filters.remove(entry)) {
            entry.removeListener(this.listener);
            if (this.filters.size() == 1) {
                this.filters.get(0).setRemoveEnabled(false);
            }
            this.scrolls.setMinSize(this.displayArea.computeSize(-1, -1));
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IFilterListener)listener).removed(entry);
                ++n2;
            }
            this.checkQuery();
        }
    }

    public void addListener(IFilterListener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeListener(IFilterListener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }
}

