/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.preferences;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mylyn.P4MylynUiUtils;
import com.perforce.team.ui.mylyn.connection.ConnectionMappingDialog;
import com.perforce.team.ui.mylyn.connection.LinkRepositoryAction;
import com.perforce.team.ui.mylyn.preferences.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ConnectionMappingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite displayArea;
    private TableViewer viewer;
    private ToolItem removeItem;
    private List<IP4Connection> unlinkedConnections = new ArrayList<IP4Connection>();
    private List<TaskRepository> unlinkedRepositories = new ArrayList<TaskRepository>();
    private List<Link> links = new ArrayList<Link>();

    public ConnectionMappingPreferencePage() {
        this.setDescription(Messages.ConnectionMappingPreferencePage_LinkConnection);
    }

    protected Control createContents(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(2, false));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createViewer(this.displayArea);
        this.createToolbar(this.displayArea);
        return this.displayArea;
    }

    private void createToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 512);
        toolbar.setLayoutData((Object)new GridData(4, 4, false, true));
        ToolItem addItem = new ToolItem(toolbar, 8);
        addItem.setToolTipText(Messages.ConnectionMappingPreferencePage_AddMapping);
        Image addImage = PerforceUIPlugin.getDescriptor((String)"normal/add.png").createImage();
        P4UIUtils.registerDisposal((Widget)addItem, (Resource)addImage);
        addItem.setImage(addImage);
        addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionMappingDialog dialog = new ConnectionMappingDialog(ConnectionMappingPreferencePage.this.getShell(), ConnectionMappingPreferencePage.this.unlinkedConnections.toArray(new IP4Connection[ConnectionMappingPreferencePage.this.unlinkedConnections.size()]), ConnectionMappingPreferencePage.this.unlinkedRepositories.toArray(new TaskRepository[ConnectionMappingPreferencePage.this.unlinkedRepositories.size()]));
                if (dialog.open() == 0) {
                    ConnectionMappingPreferencePage.this.add(dialog.getConnection(), dialog.getRepository());
                }
            }
        });
        this.removeItem = new ToolItem(toolbar, 8);
        this.removeItem.setToolTipText(Messages.ConnectionMappingPreferencePage_RemoveMapping);
        Image removeImage = PerforceUIPlugin.getDescriptor((String)"normal/delete.png").createImage();
        P4UIUtils.registerDisposal((Widget)this.removeItem, (Resource)removeImage);
        this.removeItem.setImage(removeImage);
        this.removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionMappingPreferencePage.this.remove(ConnectionMappingPreferencePage.this.getLinks());
            }
        });
        this.removeItem.setEnabled(false);
    }

    private Link[] getLinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object select = objectArray[n2];
            if (select instanceof Link) {
                links.add((Link)select);
            }
            ++n2;
        }
        return links.toArray(new Link[links.size()]);
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LinkLabelProvider());
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof Link && e2 instanceof Link) {
                    String name1 = ((Link)e1).connection.getName();
                    String name2 = ((Link)e2).connection.getName();
                    if (name1 != null && name2 != null) {
                        return name1.compareToIgnoreCase(name2);
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.viewer.getTable().setLayout((Layout)tableLayout);
        TableColumn column0 = new TableColumn(this.viewer.getTable(), 16384);
        column0.setText(Messages.ConnectionMappingPreferencePage_Connection);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 100));
        TableColumn column1 = new TableColumn(this.viewer.getTable(), 16384);
        column1.setText(Messages.ConnectionMappingPreferencePage_TaskRepository);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 100));
        this.loadLinks();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConnectionMappingPreferencePage.this.removeItem.setEnabled(ConnectionMappingPreferencePage.this.getLinks().length > 0);
            }
        });
    }

    private void add(IP4Connection connection, TaskRepository repository) {
        if (connection != null && repository != null) {
            this.unlinkedConnections.remove(connection);
            this.unlinkedRepositories.remove(repository);
            this.links.add(new Link(connection, repository));
            this.viewer.setInput(this.links);
        }
    }

    private void remove(Link[] remove) {
        Link[] linkArray = remove;
        int n = remove.length;
        int n2 = 0;
        while (n2 < n) {
            Link link = linkArray[n2];
            this.unlinkedConnections.add(link.connection);
            this.unlinkedRepositories.add(link.repository);
            this.links.remove(link);
            ++n2;
        }
        this.viewer.setInput(this.links);
    }

    private void loadLinks() {
        TaskRepository[] taskRepositoryArray = P4MylynUiUtils.getNonPerforceRepositories();
        int n = taskRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskRepository repository = taskRepositoryArray[n2];
            this.unlinkedRepositories.add(repository);
            ++n2;
        }
        taskRepositoryArray = P4ConnectionManager.getManager().getConnections();
        n = taskRepositoryArray.length;
        n2 = 0;
        while (n2 < n) {
            TaskRepository connection = taskRepositoryArray[n2];
            TaskRepository repository = P4MylynUiUtils.getRepository((IP4Connection)connection);
            if (repository != null && !"perforce".equals(repository.getConnectorKind())) {
                this.links.add(new Link((IP4Connection)connection, repository));
                this.unlinkedRepositories.remove(repository);
            } else {
                this.unlinkedConnections.add((IP4Connection)connection);
            }
            ++n2;
        }
        this.viewer.setInput(this.links);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.remove(this.links.toArray(new Link[this.links.size()]));
    }

    public boolean performOk() {
        LinkRepositoryAction linkAction = new LinkRepositoryAction();
        for (Link link : this.links) {
            linkAction.updateLink(link.connection, link.repository);
        }
        for (IP4Connection connection : this.unlinkedConnections) {
            linkAction.updateLink(connection, null);
        }
        return super.performOk();
    }

    private static class Link {
        IP4Connection connection;
        TaskRepository repository;

        Link(IP4Connection connection, TaskRepository repository) {
            this.connection = connection;
            this.repository = repository;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Link) {
                Link link = (Link)object;
                return this.connection.equals(link.connection);
            }
            return false;
        }

        public int hashCode() {
            if (this.connection != null) {
                return this.connection.hashCode();
            }
            return super.hashCode();
        }
    }

    private class LinkLabelProvider
    implements ITableLabelProvider {
        private Image connectionImage = PerforceUIPlugin.getDescriptor((String)"views/server_connection.png").createImage();
        private ILabelProvider repoDecorator = new DecoratingLabelProvider((ILabelProvider)new TaskRepositoryLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        private ILabelProviderListener wrapListener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                if (ConnectionMappingPreferencePage.this.viewer != null && !ConnectionMappingPreferencePage.this.viewer.getTable().isDisposed()) {
                    ConnectionMappingPreferencePage.this.viewer.refresh();
                }
            }
        };

        public LinkLabelProvider() {
            this.repoDecorator.addListener(this.wrapListener);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
            if (this.connectionImage != null) {
                this.connectionImage.dispose();
            }
            if (this.repoDecorator != null) {
                this.repoDecorator.removeListener(this.wrapListener);
                this.repoDecorator.dispose();
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((Link)element).connection.getName();
                }
                case 1: {
                    return ((Link)element).repository.getRepositoryLabel();
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.connectionImage;
                }
                case 1: {
                    return this.repoDecorator.getImage((Object)((Link)element).repository);
                }
            }
            return null;
        }
    }
}

