/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.job;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.mylyn.P4MylynUiUtils;
import com.perforce.team.ui.mylyn.job.IJobProxy;
import com.perforce.team.ui.mylyn.job.TaskProxy;
import java.util.ArrayList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

public class JobProxyContainer
extends PlatformObject {
    private IRepositoryQuery query;
    private IP4Connection connection;

    public JobProxyContainer(IRepositoryQuery query) {
        this.query = query;
    }

    public JobProxyContainer(IP4Connection connection) {
        this.connection = connection;
    }

    public IJobProxy[] getJobs() {
        if (this.query != null) {
            ArrayList<TaskProxy> jobs = new ArrayList<TaskProxy>();
            if (this.query instanceof ITaskContainer) {
                ITaskContainer container = (ITaskContainer)this.query;
                for (ITask task : container.getChildren()) {
                    jobs.add(new TaskProxy(task));
                }
            }
            return jobs.toArray(new IJobProxy[jobs.size()]);
        }
        return new IJobProxy[0];
    }

    public IP4Connection getConnection() {
        if (this.query != null) {
            return P4MylynUiUtils.getConnection(this.query.getConnectorKind(), this.query.getRepositoryUrl());
        }
        if (this.connection != null) {
            return this.connection;
        }
        return null;
    }
}

