/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.job;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.BaseErrorProvider;
import com.perforce.team.ui.mylyn.job.JobFieldEntry;
import com.perforce.team.ui.mylyn.job.Messages;
import com.perforce.team.ui.mylyn.search.IFilterListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class JobFieldManager
extends BaseErrorProvider {
    public static final int DEFAULT_FIELDS = 3;
    private IJobSpec spec;
    private ScrolledComposite scrolls;
    private Composite displayArea;
    private List<JobFieldEntry> filters = new ArrayList<JobFieldEntry>();
    private ListenerList listeners = new ListenerList();
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            JobFieldManager.this.checkQuery();
        }
    };

    private void checkQuery() {
        this.errorMessage = null;
        this.validate();
    }

    public void setEnabled(boolean enabled) {
        this.displayArea.setEnabled(enabled);
    }

    public void loadDefaults() {
        int i = 0;
        while (i < 3) {
            JobFieldEntry entry = new JobFieldEntry(this, this.spec);
            entry.createControl(this.displayArea);
            this.add(entry);
            ++i;
        }
    }

    public JobFieldEntry.FieldChange[] getFields() {
        ArrayList<JobFieldEntry.FieldChange> entries = new ArrayList<JobFieldEntry.FieldChange>();
        for (JobFieldEntry entry : this.filters) {
            JobFieldEntry.FieldChange filter = entry.getFilter();
            if (filter == null || filter.name == null || filter.value == null) continue;
            entries.add(filter);
        }
        return entries.toArray(new JobFieldEntry.FieldChange[entries.size()]);
    }

    public void createControl(Composite parent, IP4Connection connection) {
        this.scrolls = new ScrolledComposite(parent, 2816);
        this.scrolls.setExpandHorizontal(true);
        this.scrolls.setExpandVertical(true);
        this.scrolls.setBackground(parent.getBackground());
        this.scrolls.setBackgroundMode(1);
        this.displayArea = new Composite((Composite)this.scrolls, 0);
        this.scrolls.setContent((Control)this.displayArea);
        GridData sData = new GridData(4, 4, true, true);
        sData.heightHint = 150;
        this.scrolls.setLayoutData((Object)sData);
        this.displayArea.setLayout((Layout)new GridLayout(1, false));
        GridData baData = new GridData(4, 4, true, true);
        baData.horizontalIndent = 15;
        this.displayArea.setLayoutData((Object)baData);
        Label rulesLabel = new Label(this.displayArea, 0);
        rulesLabel.setText(Messages.JobFieldManager_ChangeFields);
        this.spec = connection.getJobSpec();
    }

    public void add(JobFieldEntry entry) {
        if (entry != null) {
            if (this.filters.size() == 1) {
                this.filters.get(0).setRemoveEnabled(true);
            }
            this.filters.add(entry);
            entry.addListener(this.listener);
            entry.setRemoveEnabled(this.filters.size() > 1);
            this.scrolls.setMinSize(this.displayArea.computeSize(-1, -1));
        }
    }

    public void remove(JobFieldEntry entry) {
        if (entry != null && this.filters.remove(entry)) {
            entry.removeListener(this.listener);
            if (this.filters.size() == 1) {
                this.filters.get(0).setRemoveEnabled(false);
            }
            this.scrolls.setMinSize(this.displayArea.computeSize(-1, -1));
        }
    }

    public void addListener(IFilterListener listener) {
        if (listener != null) {
            this.listeners.add((Object)listener);
        }
    }

    public void removeListener(IFilterListener listener) {
        if (listener != null) {
            this.listeners.remove((Object)listener);
        }
    }
}

