/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.editor;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mylyn.P4MylynUiUtils;
import com.perforce.team.ui.mylyn.editor.IRefreshEditorPart;
import com.perforce.team.ui.mylyn.editor.JobFieldGroup;
import com.perforce.team.ui.mylyn.editor.JobTaskEditorPart;
import com.perforce.team.ui.mylyn.editor.Messages;
import com.perforce.team.ui.p4java.actions.ShowHistoryAction;
import com.perforce.team.ui.timelapse.TimeLapseInput;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorDescriptionPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorPlanningPart;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;

public class P4JobEditorPage
extends AbstractTaskEditorPage {
    private static Field TASK_DATA_LISTENER;
    private JobFieldGroup page;
    private boolean isMainPage;
    private boolean allowModelRefresh = false;

    static {
        try {
            TASK_DATA_LISTENER = AbstractTaskEditorPage.class.getDeclaredField("TASK_DATA_LISTENER");
            if (TASK_DATA_LISTENER != null) {
                TASK_DATA_LISTENER.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            TASK_DATA_LISTENER = null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            TASK_DATA_LISTENER = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TASK_DATA_LISTENER = null;
        }
    }

    public P4JobEditorPage(TaskEditor editor, String id, String label, JobFieldGroup page, boolean submit, boolean isMainPage) {
        super(editor, id, label, "perforce");
        this.page = page;
        this.isMainPage = isMainPage;
        this.setNeedsPrivateSection(this.isMainPage);
        this.setNeedsSubmit(submit);
        this.setNeedsSubmitButton(submit);
        if (page == null) {
            this.scheduleRefresh();
        }
    }

    private void scheduleRefresh() {
        Job job = new Job(Messages.P4JobEditor_RefreshJobEditor){

            protected IStatus run(IProgressMonitor monitor) {
                if (P4JobEditorPage.this.page == null) {
                    TaskRepository repository = P4MylynUiUtils.getRepository(P4JobEditorPage.this.getEditor());
                    if (P4JobEditorPage.this.isMainPage) {
                        P4JobEditorPage.this.page = JobFieldGroup.loadCorePage(P4MylynUtils.getConnection((TaskRepository)repository));
                    } else {
                        P4JobEditorPage.this.page = JobFieldGroup.loadAdvancedPage(P4MylynUtils.getConnection((TaskRepository)repository));
                    }
                    P4UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            P4JobEditorPage.this.refresh();
                        }
                    });
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void showJobLookupError() {
        ITask task = this.getTask();
        if (task != null) {
            String key = task.getTaskKey();
            String message = MessageFormat.format(Messages.P4JobEditorPage_HistoryNotFound, key);
            P4ConnectionManager.getManager().openError(P4UIUtils.getDialogShell(), Messages.P4JobEditorPage_ErrorRetrievingHistory, message);
        }
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        if (this.isMainPage) {
            super.fillToolBar(toolBarManager);
            TaskData data = this.getModelTaskData();
            if (data != null && !data.isNew()) {
                toolBarManager.remove("org.eclipse.mylyn.tasklist.actions.synchronize.editor");
                Action refresh = new Action(Messages.P4JobEditorPage_Refresh){

                    public void run() {
                        SynchronizeEditorAction syncEditor = new SynchronizeEditorAction();
                        syncEditor.selectionChanged((IStructuredSelection)new StructuredSelection((Object)P4JobEditorPage.this.getTaskEditor()));
                        syncEditor.run();
                        PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                IFormPage page = P4JobEditorPage.this.getTaskEditor().findPage("jobFixes");
                                if (page instanceof IRefreshEditorPart) {
                                    ((IRefreshEditorPart)page).refresh();
                                }
                            }
                        });
                    }
                };
                refresh.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/refresh.png"));
                toolBarManager.appendToGroup("repository", (IAction)refresh);
            }
            final Action viewHistory = new Action(Messages.P4JobEditorPage_ShowHistory, PerforceUIPlugin.getDescriptor((String)"views/history.png")){

                public void run() {
                    IP4File file = P4MylynUiUtils.getJobSpecFile(P4JobEditorPage.this.getTask());
                    if (file != null) {
                        ShowHistoryAction history = new ShowHistoryAction();
                        history.selectionChanged(null, (ISelection)new StructuredSelection((Object)file));
                        history.run(null);
                    } else {
                        P4JobEditorPage.this.showJobLookupError();
                    }
                }
            };
            viewHistory.setEnabled(false);
            toolBarManager.appendToGroup("open", (IAction)viewHistory);
            final Action timeLapse = new Action(Messages.P4JobEditorPage_ViewTimeLapse, PerforceUIPlugin.getDescriptor((String)"normal/time_lapse.png")){

                public void run() {
                    IP4File file = P4MylynUiUtils.getJobSpecFile(P4JobEditorPage.this.getTask());
                    if (file != null) {
                        TimeLapseInput input = new TimeLapseInput(file, false, false);
                        try {
                            IDE.openEditor((IWorkbenchPage)PerforceUIPlugin.getActivePage(), (IEditorInput)input, (String)"com.perforce.team.ui.text.timelapse.form.FormTimeLapseEditor");
                        }
                        catch (PartInitException e) {
                            PerforceProviderPlugin.logError((Throwable)e);
                        }
                    } else {
                        P4JobEditorPage.this.showJobLookupError();
                    }
                }
            };
            timeLapse.setEnabled(false);
            toolBarManager.appendToGroup("open", (IAction)timeLapse);
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    IP4Connection connection = P4MylynUiUtils.getConnection(P4JobEditorPage.this.getTask());
                    if (connection != null && !connection.isOffline()) {
                        P4Depot spec;
                        if (connection.needsRefresh()) {
                            connection.refresh();
                        }
                        if ((spec = connection.getSpecDepot()) != null) {
                            viewHistory.setEnabled(true);
                            timeLapse.setEnabled(true);
                        }
                    }
                }
            });
        }
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        LinkedHashSet<TaskEditorPartDescriptor> descriptors = new LinkedHashSet<TaskEditorPartDescriptor>();
        TaskEditorPartDescriptor attributes = new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.attributes"){

            public AbstractTaskEditorPart createPart() {
                JobTaskEditorPart part = new JobTaskEditorPart(P4JobEditorPage.this.page);
                return part;
            }
        };
        attributes.setPath("attributes");
        descriptors.add(attributes);
        if (this.isMainPage) {
            if (this.needsPrivateSection()) {
                descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.planning"){

                    public AbstractTaskEditorPart createPart() {
                        return new TaskEditorPlanningPart();
                    }
                }.setPath("attributes"));
            }
            TaskEditorPartDescriptor description = new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.descriptions"){

                public AbstractTaskEditorPart createPart() {
                    TaskEditorDescriptionPart part = new TaskEditorDescriptionPart(){

                        protected void fillToolBar(ToolBarManager toolBar) {
                            super.fillToolBar(toolBar);
                            IContributionItem[] iContributionItemArray = toolBar.getItems();
                            int n = iContributionItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ActionContributionItem ai;
                                IContributionItem item = iContributionItemArray[n2];
                                if (item instanceof ActionContributionItem && (ai = (ActionContributionItem)item).getAction().getImageDescriptor() == TasksUiImages.COMMENT_REPLY_SMALL) {
                                    toolBar.remove(item);
                                }
                                ++n2;
                            }
                        }
                    };
                    part.setExpandVertically(true);
                    return part;
                }
            };
            description.setPath("attributes");
            descriptors.add(description);
        }
        return descriptors;
    }

    private TaskDataModel createMainTaskDataModel(TaskEditorInput input) throws CoreException {
        ITaskDataWorkingCopy taskDataState = null;
        try {
            taskDataState = TasksUi.getTaskDataManager().getWorkingCopy(this.getTask());
        }
        catch (OperationCanceledException operationCanceledException) {
            taskDataState = TasksUi.getTaskDataManager().getWorkingCopy(this.getTask());
        }
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(taskDataState.getConnectorKind(), taskDataState.getRepositoryUrl());
        return new TaskDataModel(taskRepository, input.getTask(), taskDataState){

            public void refresh(IProgressMonitor monitor) throws CoreException {
                if (P4JobEditorPage.this.allowModelRefresh) {
                    super.refresh(monitor);
                }
            }
        };
    }

    protected TaskDataModel createModel(TaskEditorInput input) throws CoreException {
        TaskDataModel model = null;
        if (!this.isMainPage) {
            IFormPage main = this.getTaskEditor().findPage("Job");
            if (main instanceof P4JobEditorPage) {
                model = ((P4JobEditorPage)main).getModel();
            }
        } else {
            model = this.createMainTaskDataModel(input);
        }
        if (model == null) {
            model = super.createModel(input);
        }
        return model;
    }

    public void refresh() {
        IFormPage advanced;
        this.allowModelRefresh = true;
        try {
            super.refresh();
        }
        finally {
            this.allowModelRefresh = false;
        }
        if (this.isMainPage && (advanced = this.getTaskEditor().findPage("Other")) instanceof P4JobEditorPage) {
            ((P4JobEditorPage)advanced).refresh();
        }
    }

    private TaskData getModelTaskData() {
        TaskData data = null;
        TaskDataModel model = this.getModel();
        if (model != null) {
            data = model.getTaskData();
        }
        return data;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (!this.isMainPage) {
            this.getEditor().setActivePage("Other");
            this.getEditor().setActivePage("Job");
            if (TASK_DATA_LISTENER != null) {
                try {
                    TaskDataManager manager;
                    Object taskDataListener = TASK_DATA_LISTENER.get((Object)this);
                    if (taskDataListener instanceof ITaskDataManagerListener && (manager = TasksUiPlugin.getTaskDataManager()) != null) {
                        manager.removeListener((ITaskDataManagerListener)taskDataListener);
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
    }
}

