/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.editor;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.mylyn.PerforceUiMylynPlugin;
import com.perforce.team.ui.mylyn.editor.JobField;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class JobFieldGroup {
    public static final String BASE_FIELDS = "com.perforce.team.ui.mylyn.editor.PAGE_FIELDS_";
    public static final String FIELDS = "fields";
    public static final String ENTRY = "entry";
    public static final String NAME = "name";
    public static final String CORE_FIELDS = "Job";
    public static final String ADVANCED_FIELDS = "Other";
    private IP4Connection connection;
    private String title;
    private List<JobField> fields;
    private JobField description;
    private int index = -1;

    public static JobFieldGroup loadDefaultPages(IP4Connection connection, String pageName) {
        IJobSpec spec;
        JobFieldGroup page = null;
        if (connection != null && CORE_FIELDS.equals(pageName) && (spec = connection.getJobSpec()) != null) {
            page = new JobFieldGroup(connection, pageName);
            for (IJobSpec.IJobSpecField field : spec.getFields()) {
                page.add(new JobField(page, field));
            }
        }
        return page;
    }

    public static JobFieldGroup loadDefaultPages(TaskRepository repository, String pageName) {
        return JobFieldGroup.loadDefaultPages(P4MylynUtils.getConnection((TaskRepository)repository), pageName);
    }

    public static JobFieldGroup loadCorePage(IP4Connection connection) {
        IJobSpec spec;
        JobFieldGroup page = null;
        if (connection != null && (spec = connection.getJobSpec()) != null) {
            HashMap<String, IJobSpec.IJobSpecField> specFields = new HashMap<String, IJobSpec.IJobSpecField>();
            ArrayList<IJobSpec.IJobSpecField> totalFields = new ArrayList<IJobSpec.IJobSpecField>();
            for (IJobSpec.IJobSpecField field : spec.getFields()) {
                specFields.put(field.getName(), field);
                totalFields.add(field);
            }
            page = JobFieldGroup.loadCoreGroup(connection, specFields);
            JobFieldGroup advanced = JobFieldGroup.loadAdvancedGroup(connection, specFields);
            if (page != null) {
                JobField[] jobFieldArray = page.getFields();
                int n = jobFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JobField jobField = jobFieldArray[n2];
                    totalFields.remove(jobField.getField());
                    ++n2;
                }
                if (advanced.getFields().length == 0) {
                    for (IJobSpec.IJobSpecField iJobSpecField : totalFields) {
                        page.add(new JobField(page, iJobSpecField));
                    }
                }
            }
        }
        return page;
    }

    private static JobFieldGroup loadCoreGroup(IP4Connection connection, Map<String, IJobSpec.IJobSpecField> specFields) {
        String pagePref = "com.perforce.team.ui.mylyn.editor.PAGE_FIELDS_Job" + connection.getParameters().getPort();
        if (PerforceUiMylynPlugin.getDefault().getPreferenceStore().isDefault(pagePref)) {
            return JobFieldGroup.loadDefaultPages(connection, CORE_FIELDS);
        }
        JobFieldGroup page = new JobFieldGroup(connection, CORE_FIELDS);
        JobFieldGroup.fillGroup(page, pagePref, specFields);
        return page;
    }

    private static JobFieldGroup loadAdvancedGroup(IP4Connection connection, Map<String, IJobSpec.IJobSpecField> specFields) {
        String pagePref = "com.perforce.team.ui.mylyn.editor.PAGE_FIELDS_Other" + connection.getParameters().getPort();
        JobFieldGroup page = new JobFieldGroup(connection, ADVANCED_FIELDS);
        JobFieldGroup.fillGroup(page, pagePref, specFields);
        return page;
    }

    private static void fillGroup(JobFieldGroup page, String pagePref, Map<String, IJobSpec.IJobSpecField> specFields) {
        String pageValue = PerforceUiMylynPlugin.getDefault().getPreferenceStore().getString(pagePref);
        if (pageValue.length() > 0) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(pageValue));
                IMemento[] iMementoArray = memento.getChildren(ENTRY);
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento field = iMementoArray[n2];
                    IJobSpec.IJobSpecField specField = specFields.get(field.getString(NAME));
                    if (specField != null) {
                        page.add(new JobField(page, specField));
                    }
                    ++n2;
                }
            }
            catch (WorkbenchException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }

    public static JobFieldGroup loadAdvancedPage(IP4Connection connection) {
        IJobSpec spec;
        JobFieldGroup page = null;
        if (connection != null && (spec = connection.getJobSpec()) != null) {
            HashMap<String, IJobSpec.IJobSpecField> specFields = new HashMap<String, IJobSpec.IJobSpecField>();
            ArrayList<IJobSpec.IJobSpecField> totalFields = new ArrayList<IJobSpec.IJobSpecField>();
            for (Object field : spec.getFields()) {
                specFields.put(field.getName(), (IJobSpec.IJobSpecField)field);
                totalFields.add((IJobSpec.IJobSpecField)field);
            }
            page = JobFieldGroup.loadAdvancedGroup(connection, specFields);
            if (page.getFields().length > 0) {
                JobField[] jobFieldArray = page.getFields();
                int n = jobFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object field;
                    field = jobFieldArray[n2];
                    totalFields.remove(((JobField)field).getField());
                    ++n2;
                }
                JobFieldGroup core = JobFieldGroup.loadCoreGroup(connection, specFields);
                if (core != null) {
                    JobField[] jobFieldArray2 = core.getFields();
                    int n3 = jobFieldArray2.length;
                    n = 0;
                    while (n < n3) {
                        JobField field = jobFieldArray2[n];
                        totalFields.remove(field.getField());
                        ++n;
                    }
                }
                for (IJobSpec.IJobSpecField field : totalFields) {
                    page.add(new JobField(page, field));
                }
            }
        }
        return page;
    }

    public static JobFieldGroup loadPage(IP4Connection connection, String pageName) {
        JobFieldGroup group = null;
        if (CORE_FIELDS.equals(pageName)) {
            group = JobFieldGroup.loadCorePage(connection);
        } else if (ADVANCED_FIELDS.equals(pageName)) {
            group = JobFieldGroup.loadAdvancedPage(connection);
        }
        return group;
    }

    public static JobFieldGroup loadPage(TaskRepository repository, String pageName) {
        return JobFieldGroup.loadPage(P4MylynUtils.getConnection((TaskRepository)repository), pageName);
    }

    public static void savePages(IP4Connection connection, JobFieldGroup[] pages) {
        if (connection != null && pages != null) {
            JobFieldGroup[] jobFieldGroupArray = pages;
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                JobFieldGroup page = jobFieldGroupArray[n2];
                String pagePref = BASE_FIELDS + page.getTitle() + connection.getParameters().getPort();
                XMLMemento memento = XMLMemento.createWriteRoot((String)FIELDS);
                JobField[] jobFieldArray = page.getFields();
                int n3 = jobFieldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    JobField field = jobFieldArray[n4];
                    IMemento child = memento.createChild(ENTRY);
                    child.putString(NAME, field.getField().getName());
                    ++n4;
                }
                StringWriter writer = new StringWriter();
                try {
                    memento.save((Writer)writer);
                    PerforceUiMylynPlugin.getDefault().getPreferenceStore().setValue(pagePref, writer.toString());
                }
                catch (IOException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
                ++n2;
            }
        }
    }

    public JobFieldGroup(IP4Connection connection, String title) {
        this.connection = connection;
        this.title = title;
        this.fields = new ArrayList<JobField>();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public IP4Connection getConnection() {
        return this.connection;
    }

    public String getTitle() {
        return this.title;
    }

    public void add(JobField field) {
        if (field != null) {
            if (field.getField().getCode() != 105) {
                this.fields.add(field);
            } else {
                this.description = field;
            }
        }
    }

    public int indexOf(JobField field) {
        int index = -1;
        if (field != null) {
            index = field.getField().getCode() != 105 ? this.fields.indexOf(field) : this.fields.size();
        }
        return index;
    }

    public void addAll(Collection<JobField> fields) {
        if (fields != null) {
            this.fields.addAll(fields);
        }
    }

    public void remove(JobField field) {
        if (field != null) {
            this.fields.remove(field);
        }
    }

    public void move(JobField[] elements, int index) {
        if (elements != null && index > -1) {
            Arrays.sort(elements, new Comparator<JobField>(){

                @Override
                public int compare(JobField f1, JobField f2) {
                    if (f1.getParent() == f2.getParent()) {
                        return f1.getIndex() - f2.getIndex();
                    }
                    return f1.getParentIndex() - f2.getParentIndex();
                }
            });
            JobField[] jobFieldArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                JobField field = jobFieldArray[n2];
                int found = this.fields.indexOf(field);
                if (found > -1) {
                    if (index > found) {
                        --index;
                    }
                    this.fields.remove(found);
                }
                field.setParent(this);
                if (index > -1 && index <= this.fields.size()) {
                    this.fields.add(index, field);
                }
                ++index;
                ++n2;
            }
        }
    }

    public JobField[] getFields() {
        if (this.description == null) {
            return this.fields.toArray(new JobField[this.fields.size()]);
        }
        JobField[] jobFields = this.fields.toArray(new JobField[this.fields.size() + 1]);
        jobFields[jobFields.length - 1] = this.description;
        return jobFields;
    }
}

