/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.editor;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.DecoratedChangelistLabelProvider;
import com.perforce.team.ui.mylyn.editor.IFixEditorPart;
import com.perforce.team.ui.mylyn.editor.Messages;
import com.perforce.team.ui.p4java.actions.EditJobAction;
import com.perforce.team.ui.p4java.actions.ViewChangelistAction;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public abstract class ChangelistFixWidget
implements IFixEditorPart,
IP4Listener {
    private Composite displayArea;
    protected TreeViewer viewer = null;
    protected String id = null;
    protected Set<IP4Changelist> lists = null;
    private boolean enableEdit = false;
    private Runnable callback = null;

    public ChangelistFixWidget(boolean enableEdit, String id) {
        this.enableEdit = enableEdit;
        this.id = id;
        this.lists = new HashSet<IP4Changelist>(0);
    }

    public void setCallback(Runnable callback) {
        this.callback = callback;
    }

    protected void createToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        this.fillToolbar(toolbar);
    }

    protected void fillToolbar(ToolBar toolbar) {
        ToolItem expand = new ToolItem(toolbar, 8);
        Image expandImage = PerforceUIPlugin.getDescriptor((String)"normal/expandall.png").createImage();
        P4UIUtils.registerDisposal((Widget)expand, (Resource)expandImage);
        expand.setImage(expandImage);
        expand.setToolTipText(Messages.ChangelistFixWidget_ExpandAll);
        expand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangelistFixWidget.this.viewer.expandAll();
            }
        });
        ToolItem collapse = new ToolItem(toolbar, 8);
        collapse.setToolTipText(Messages.ChangelistFixWidget_CollapseAll);
        Image collapseImage = PerforceUIPlugin.getDescriptor((String)"normal/collapseall.png").createImage();
        P4UIUtils.registerDisposal((Widget)collapse, (Resource)collapseImage);
        collapse.setImage(collapseImage);
        collapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangelistFixWidget.this.viewer.collapseAll();
            }
        });
    }

    private void createFixArea(Composite parent) {
        this.viewer = new TreeViewer(parent, 2818);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setLabelProvider((IBaseLabelProvider)DecoratedChangelistLabelProvider.create());
        this.viewer.setContentProvider((IContentProvider)this.createContentProvider(this.viewer));
        if (this.enableEdit) {
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = ChangelistFixWidget.this.viewer.getSelection();
                    ViewChangelistAction view = new ViewChangelistAction();
                    view.selectionChanged(null, selection);
                    view.run(null);
                    EditJobAction edit = new EditJobAction();
                    edit.selectionChanged(null, selection);
                    edit.doubleClick(null);
                    ChangelistFixWidget.this.openEditor(selection);
                }
            });
        }
        this.configureViewer(this.viewer);
    }

    protected abstract void openEditor(ISelection var1);

    protected ITreeContentProvider createContentProvider(TreeViewer viewer) {
        return new PerforceContentProvider((StructuredViewer)viewer, true);
    }

    protected void configureViewer(TreeViewer viewer) {
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (ChangelistFixWidget.this.id != null && element instanceof IP4Job) {
                    IP4Job job = (IP4Job)element;
                    return !ChangelistFixWidget.this.id.equals(job.getId());
                }
                return true;
            }
        });
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(1, true));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createToolbar(this.displayArea);
        this.createFixArea(this.displayArea);
        P4Workspace.getWorkspace().addListener((IP4Listener)this);
        this.displayArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                P4Workspace.getWorkspace().removeListener((IP4Listener)ChangelistFixWidget.this);
            }
        });
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void showLoading() {
        IContentProvider provider;
        if (P4UIUtils.okToUse((Viewer)this.viewer) && (provider = this.viewer.getContentProvider()) instanceof PerforceContentProvider) {
            this.viewer.setInput((Object)new PerforceContentProvider.Loading());
        }
    }

    private boolean isMatchingJob(IP4Job job) {
        return this.id.equals(job.getId());
    }

    protected abstract boolean isValid(IP4Resource var1);

    public void resoureChanged(P4Event event) {
        final P4Event.EventType type = event.getType();
        if (type == P4Event.EventType.FIXED || type == P4Event.EventType.UNFIXED) {
            IP4Job[] iP4JobArray = event.getJobs();
            int n = iP4JobArray.length;
            int n2 = 0;
            while (n2 < n) {
                final IP4Job job = iP4JobArray[n2];
                if (this.isMatchingJob(job)) {
                    UIJob refresh = new UIJob(Messages.ChangelistFixWidget_UpdatingChangelists){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!P4UIUtils.okToUse((Viewer)ChangelistFixWidget.this.viewer)) {
                                return Status.CANCEL_STATUS;
                            }
                            IP4Container parent = job.getParent();
                            if (ChangelistFixWidget.this.isValid((IP4Resource)parent)) {
                                if (type == P4Event.EventType.FIXED) {
                                    ChangelistFixWidget.this.lists.add((IP4Changelist)parent);
                                } else if (type == P4Event.EventType.UNFIXED) {
                                    ChangelistFixWidget.this.lists.remove(parent);
                                }
                                ChangelistFixWidget.this.viewer.refresh();
                                if (ChangelistFixWidget.this.callback != null) {
                                    ChangelistFixWidget.this.callback.run();
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    refresh.schedule();
                    break;
                }
                ++n2;
            }
        }
    }

    @Override
    public int setFixes(IP4Changelist[] fixes) {
        HashSet<IP4Changelist> changelists = new HashSet<IP4Changelist>();
        IP4Changelist[] iP4ChangelistArray = fixes;
        int n = fixes.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Changelist fix = iP4ChangelistArray[n2];
            if (this.isValid((IP4Resource)fix)) {
                changelists.add(fix);
            }
            ++n2;
        }
        this.lists = changelists;
        PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (P4UIUtils.okToUse((Viewer)ChangelistFixWidget.this.viewer)) {
                    ChangelistFixWidget.this.viewer.setInput(ChangelistFixWidget.this.lists);
                }
            }
        });
        return this.lists.size();
    }

    public int getSize() {
        return this.lists.size();
    }

    public boolean contains(IP4Changelist list) {
        return list != null ? Boolean.valueOf(this.lists.contains(list)) : null;
    }

    public String getName() {
        return ChangelistFixWidget.class.getSimpleName();
    }
}

