/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.changeset;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.synchronize.IP4ReusableChangeSet;
import com.perforce.team.core.p4java.synchronize.P4PendingChangeSet;
import com.perforce.team.ui.mylyn.IPendingChangelistLocator;
import com.perforce.team.ui.mylyn.P4JobConnectorUi;
import com.perforce.team.ui.mylyn.P4MylynUiUtils;
import com.perforce.team.ui.mylyn.PerforceUiMylynPlugin;
import com.perforce.team.ui.mylyn.changeset.Messages;
import com.perforce.team.ui.p4java.actions.FixJobAction;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.team.ui.ContextChangeSet;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.resources.ui.ResourcesUi;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.team.ui.AbstractTaskReference;
import org.eclipse.mylyn.team.ui.IContextChangeSet;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.provider.ThreeWayDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.osgi.service.prefs.Preferences;

public class P4ContextChangeSet
extends P4PendingChangeSet
implements IAdaptable,
IContextChangeSet,
IP4ReusableChangeSet {
    private static final String CTX_PERSISTANCE_TITLE = "title";
    private static final String PERSITANCE_TITLE = "{0} ({1})";
    public static final int CONTEXT_PRIORITY = 3;
    private boolean suppressInterestContribution = false;
    private IP4Connection connection;
    private ITask task;
    private IPendingChangelistLocator locator;
    private IPendingChangelistLocator.ITaskLocatorToken token;

    public P4ContextChangeSet(ITask task, IP4Connection connection, ActiveChangeSetManager manager) {
        super(manager, task.getSummary());
        this.task = task;
        this.connection = connection;
        this.initializeChangelist();
    }

    private void initializeChangelist() {
        P4JobConnectorUi connector = P4MylynUiUtils.getPerforceConnectorUi();
        this.locator = connector.getChangelistLocator(this.task);
        String comment = connector.getChangelistDescription(this.task);
        IP4PendingChangelist[] lists = null;
        lists = this.connection.isPendingLoaded() ? this.connection.getCachedPendingChangelists() : this.connection.getPendingChangelists(false);
        this.list = this.locator != null ? this.locator.find(lists, this.task) : this.findList(comment, lists);
        if (this.list == null) {
            this.list = this.connection.createChangelist(comment, null);
        } else if (this.list.needsRefresh()) {
            this.list.refresh();
        }
        if (this.list != null) {
            this.id = this.list.getId();
        }
        this.fixJob();
        this.updateTitle();
    }

    public void save(Preferences prefs) {
        super.save(prefs);
        prefs.put(CTX_PERSISTANCE_TITLE, this.getTitleForPersistance());
        prefs.put("savedComment", this.getComment());
    }

    private String getTitleForPersistance() {
        return MessageFormat.format(PERSITANCE_TITLE, this.getTitle(), this.task.getHandleIdentifier());
    }

    private void fixJob() {
        if (this.list == null) {
            return;
        }
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                IP4Job job = P4ContextChangeSet.this.connection.getJob(P4ContextChangeSet.this.task.getTaskKey());
                if (job != null) {
                    FixJobAction fix = new FixJobAction();
                    fix.setAsync(false);
                    fix.fix((IP4Changelist)P4ContextChangeSet.this.list, job);
                }
            }

            public String getTitle() {
                return MessageFormat.format(Messages.P4ContextChangeSet_FixJobChangelist, P4ContextChangeSet.this.task.getTaskKey(), P4ContextChangeSet.this.list.getId());
            }
        });
    }

    private IP4PendingChangelist findList(String comment, IP4PendingChangelist[] lists) {
        IP4PendingChangelist list = null;
        IP4PendingChangelist[] iP4PendingChangelistArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            IP4PendingChangelist pending = iP4PendingChangelistArray[n2];
            if (comment.equals(pending.getDescription().trim())) {
                list = pending;
                break;
            }
            ++n2;
        }
        return list;
    }

    public String getComment() {
        return this.getComment(true);
    }

    public String getComment(boolean checkTaskRepository) {
        return ContextChangeSet.getComment((boolean)checkTaskRepository, (ITask)this.task, (IResource[])this.getResources());
    }

    public Object getAdapter(Class adapter) {
        Object adapted = null;
        adapted = AbstractTask.class == adapter ? this.getTask() : (AbstractTaskReference.class == adapter ? new LinkedTaskInfo(this.getTask(), (ChangeSet)this) : Platform.getAdapterManager().getAdapter((Object)this, adapter));
        return adapted;
    }

    public ITask getTask() {
        return this.task;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof P4ContextChangeSet) {
            return this.task.equals(((P4ContextChangeSet)((Object)object)).getTask()) && super.equals(object);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (this.task != null) {
            return this.task.hashCode();
        }
        return super.hashCode();
    }

    protected void updateTitle() {
        this.setTitle(this.task.getSummary());
    }

    public void updateLabel() {
        this.updateTitle();
        if (this.isValid() && this.locator != null) {
            this.token = this.locator.update(this.list, this.task, this.token);
        }
    }

    private IResource getResourceFromDiff(IDiff diff) {
        if (diff instanceof ResourceDiff) {
            return ((ResourceDiff)diff).getResource();
        }
        if (diff instanceof ThreeWayDiff) {
            ThreeWayDiff threeWayDiff = (ThreeWayDiff)diff;
            return ResourcesPlugin.getWorkspace().getRoot().findMember(threeWayDiff.getPath());
        }
        return null;
    }

    public void add(IDiff diff) {
        super.add(diff);
        IResource resource = this.getResourceFromDiff(diff);
        if (!this.suppressInterestContribution && resource != null) {
            HashSet<IResource> resources = new HashSet<IResource>();
            resources.add(resource);
            if (ResourcesUiBridgePlugin.getDefault() != null) {
                ResourcesUi.addResourceToContext(resources, (InteractionEvent.Kind)InteractionEvent.Kind.SELECTION);
            }
        }
    }

    public void restoreResources(IResource[] newResources) throws CoreException {
        this.suppressInterestContribution = true;
        try {
            this.add(newResources);
            this.setComment(this.getComment(false));
        }
        finally {
            this.suppressInterestContribution = false;
        }
    }

    public int getPriority() {
        return 3;
    }

    public boolean useCommentOnSubmit() {
        return true;
    }

    private boolean recreateChangelists() {
        return PerforceUiMylynPlugin.getDefault().getPreferenceStore().getBoolean("com.perforce.team.ui.mylyn.preferences.RECREATE_CHANGELISTS");
    }

    public boolean activate(IP4File[] files) {
        if (!this.task.isActive() || !this.recreateChangelists()) {
            return false;
        }
        this.list = null;
        this.initializeChangelist();
        IP4PendingChangelist newList = this.list;
        if (newList != null) {
            new P4Collection((IP4Resource[])files).reopen(newList);
        }
        return newList != null;
    }
}

