/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn;

import com.perforce.team.core.mylyn.P4DefaultJobConfiguration;
import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.ui.mylyn.IP4JobUiConfiguration;
import com.perforce.team.ui.mylyn.IP4JobUiConfiguration2;
import com.perforce.team.ui.mylyn.IPendingChangelistLocator;
import com.perforce.team.ui.mylyn.Messages;
import com.perforce.team.ui.mylyn.P4DefaultPendingChangelistLocator;
import com.perforce.team.ui.mylyn.PerforceUiMylynPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.LegendElement;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.ui.PlatformUI;

public class P4DefaultJobUiConfiguration
implements IP4JobUiConfiguration,
IP4JobUiConfiguration2 {
    public static final String COMMENT_PATTERN = Messages.P4DefaultJobUiConfiguration_WorkingChangelistDescription;
    private IPendingChangelistLocator locator = new P4DefaultPendingChangelistLocator();

    @Override
    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int index, int textOffset) {
        Matcher matcher = P4DefaultJobConfiguration.JOB_PATTERN.matcher(text);
        ArrayList<P4TaskHyperlink> links = new ArrayList<P4TaskHyperlink>();
        while (matcher.find()) {
            if (index != -1 && (matcher.start() >= index || matcher.end() <= index)) continue;
            String jobName = matcher.group();
            Region region = new Region(textOffset + matcher.start(), jobName.length());
            links.add(new P4TaskHyperlink((IRegion)region, repository, jobName));
        }
        return links.isEmpty() ? null : links.toArray(new IHyperlink[links.size()]);
    }

    @Override
    public ImageDescriptor getTaskKindOverlay(ITask task) {
        return null;
    }

    public boolean isConfigurationFor(TaskRepository repository) {
        return true;
    }

    @Override
    public String getReplyText(TaskRepository taskRepository, ITask task, ITaskComment taskComment, boolean includeTask) {
        if (taskComment != null) {
            return MessageFormat.format(Messages.P4DefaultJobUiConfiguration_CommentReplyText, taskComment.getNumber());
        }
        return null;
    }

    @Override
    public String getTaskKindLabel(ITask task) {
        return "Job";
    }

    @Override
    public ImageDescriptor getTaskPriorityOverlay(ITask task) {
        return null;
    }

    @Override
    public Collection<LegendElement> getLegendElements() {
        return Collections.emptyList();
    }

    @Override
    public String getContextChangelistDescription(TaskRepository taskRepository, ITask task) {
        IPendingChangelistLocator.ITaskLocatorToken token = this.locator.generateToken(task);
        return P4DefaultJobUiConfiguration.getCommitComment(task, token);
    }

    @Override
    public IPendingChangelistLocator getPendingChangelistLocator() {
        return this.locator;
    }

    public static String getCommitComment(ITask task, IPendingChangelistLocator.ITaskLocatorToken token) {
        boolean useMylyn = PerforceUiMylynPlugin.getDefault().getPreferenceStore().getBoolean("com.perforce.team.ui.mylyn.preferences.USE_MYLYN_TEAM_COMMENT");
        if (useMylyn) {
            String template = FocusedTeamUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.team.commit.template");
            if (template != null) {
                return FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().generateComment(task, template);
            }
            return "";
        }
        return token != null ? token.getComment() : "";
    }

    private static class P4TaskHyperlink
    implements IHyperlink {
        TaskHyperlink link;

        public P4TaskHyperlink(IRegion region, TaskRepository repository, String taskId) {
            this.link = new TaskHyperlink(region, repository, taskId);
        }

        public IRegion getHyperlinkRegion() {
            return this.link.getHyperlinkRegion();
        }

        public String getTypeLabel() {
            return this.link.getTypeLabel();
        }

        public String getHyperlinkText() {
            return this.link.getHyperlinkText();
        }

        public void open() {
            Job job = new Job(MessageFormat.format(Messages.P4DefaultJobUiConfiguration_OpenJob, this.link.getTaskId())){
                boolean jobExist;
                {
                    this.jobExist = false;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("", 100);
                    monitor.worked(20);
                    TaskRepository repository = P4TaskHyperlink.this.link.getRepository();
                    String taskId = P4TaskHyperlink.this.link.getTaskId();
                    if (repository != null) {
                        ITask task = TasksUiPlugin.getTaskList().getTask(repository.getRepositoryUrl(), taskId);
                        if (task == null) {
                            task = TasksUiPlugin.getTaskList().getTaskByKey(repository.getRepositoryUrl(), taskId);
                        }
                        if (task == null) {
                            IP4Connection connection = P4MylynUtils.getConnection((TaskRepository)repository);
                            IP4Job[] existJobs = connection.getJobs(null, 1, "Job=" + taskId);
                            monitor.worked(50);
                            if (existJobs.length == 1) {
                                this.jobExist = true;
                            }
                        } else {
                            this.jobExist = true;
                        }
                    }
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (jobExist) {
                                (this).P4TaskHyperlink.this.link.open();
                            } else {
                                MessageDialog.openError(null, (String)Messages.P4DefaultJobUiConfiguration_Error, (String)MessageFormat.format(Messages.P4DefaultJobUiConfiguration_TaskDoesnotExist, (this).P4TaskHyperlink.this.link.getTaskId()));
                            }
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

