/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.results;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.Folder;
import com.perforce.team.ui.search.P4UiSearchPlugin;
import com.perforce.team.ui.search.results.FileMatch;
import com.perforce.team.ui.search.results.ISearchResultProvider;
import com.perforce.team.ui.search.results.Messages;
import com.perforce.team.ui.search.results.P4SearchResult;
import com.perforce.team.ui.search.results.RevisionMatch;
import com.perforce.team.ui.search.results.SearchLabelDecorator;
import com.perforce.team.ui.search.results.SearchResultsOpenHandler;
import com.perforce.team.ui.search.results.table.SearchTableContentProvider;
import com.perforce.team.ui.search.results.table.SearchTableLabelProvider;
import com.perforce.team.ui.search.results.table.SearchTableResultsSorter;
import com.perforce.team.ui.search.results.tree.SearchTreeContentProvider;
import com.perforce.team.ui.search.results.tree.SearchTreeLabelProvider;
import com.perforce.team.ui.search.results.tree.SearchTreeResultsSorter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;

public class P4SearchResultPage
extends AbstractTextSearchViewPage
implements ISearchResultProvider {
    public static final String RESULTS_MODE_GROUP = "RESULTS_MODE_GROUP";
    private SearchResultsOpenHandler openHandler = new SearchResultsOpenHandler();
    private IAction flatMode;
    private IAction treeMode;
    private IAction compressedMode;
    private SearchTreeContentProvider treeContentProvider = null;
    private SearchTreeLabelProvider labelProvider = null;

    public P4SearchResultPage() {
        this.createActions();
    }

    public P4SearchResultPage(int layouts) {
        super(layouts);
        this.createActions();
    }

    private void createActions() {
        final IPreferenceStore store = P4UiSearchPlugin.getDefault().getPreferenceStore();
        this.flatMode = new Action(Messages.P4SearchResultPage_FlatMode, 8){

            public void run() {
                if (P4SearchResultPage.this.treeContentProvider != null) {
                    boolean checked = this.isChecked();
                    P4SearchResultPage.this.labelProvider.setShowFileNames(!checked);
                    P4SearchResultPage.this.treeContentProvider.setDisplayType(Folder.Type.FLAT);
                    P4SearchResultPage.this.treeContentProvider.refresh();
                    P4SearchResultPage.this.postEnsureSelection();
                    store.setValue("RESULTS_TREE_MODE", checked);
                }
            }
        };
        this.flatMode.setEnabled(false);
        this.flatMode.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/flat_layout.png"));
        this.flatMode.setChecked(store.getBoolean("RESULTS_FLAT_MODE"));
        this.compressedMode = new Action(Messages.P4SearchResultPage_CompressedMode, 8){

            public void run() {
                if (P4SearchResultPage.this.treeContentProvider != null) {
                    boolean checked = this.isChecked();
                    P4SearchResultPage.this.labelProvider.setShowFileNames(checked);
                    P4SearchResultPage.this.treeContentProvider.setDisplayType(Folder.Type.COMPRESSED);
                    P4SearchResultPage.this.treeContentProvider.refresh();
                    P4SearchResultPage.this.postEnsureSelection();
                    store.setValue("RESULTS_COMPRESSED_MODE", checked);
                }
            }
        };
        this.compressedMode.setEnabled(false);
        this.compressedMode.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/compressed_folders_layout.png"));
        this.compressedMode.setChecked(store.getBoolean("RESULTS_COMPRESSED_MODE"));
        this.treeMode = new Action(Messages.P4SearchResultPage_TreeMode, 8){

            public void run() {
                if (P4SearchResultPage.this.treeContentProvider != null) {
                    boolean checked = this.isChecked();
                    P4SearchResultPage.this.labelProvider.setShowFileNames(checked);
                    P4SearchResultPage.this.treeContentProvider.setDisplayType(Folder.Type.TREE);
                    P4SearchResultPage.this.treeContentProvider.refresh();
                    P4SearchResultPage.this.postEnsureSelection();
                    store.setValue("RESULTS_TREE_MODE", checked);
                }
            }
        };
        this.treeMode.setEnabled(false);
        this.treeMode.setImageDescriptor(PerforceUIPlugin.getDescriptor((String)"normal/tree_layout.png"));
        this.treeMode.setChecked(store.getBoolean("RESULTS_TREE_MODE"));
        if (!this.treeMode.isChecked() && !this.compressedMode.isChecked()) {
            this.flatMode.setChecked(true);
        }
    }

    protected void clear() {
        this.getViewer().refresh();
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (this.treeContentProvider != null && firstElement instanceof RevisionMatch) {
            Match[] matches = this.getDisplayedMatches(firstElement);
            if (matches != null && matches.length > 0) {
                try {
                    this.showMatch(matches[0], 0, 0, true);
                }
                catch (PartInitException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
            }
        } else {
            super.handleOpen(event);
        }
    }

    public int getDisplayedMatchCount(Object element) {
        if (element instanceof FileMatch) {
            return 1;
        }
        return 0;
    }

    public Match[] getDisplayedMatches(Object element) {
        if (element instanceof FileMatch) {
            return new Match[]{(Match)element};
        }
        return super.getDisplayedMatches(element);
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.treeContentProvider = null;
        this.labelProvider = null;
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new SearchTableContentProvider((StructuredViewer)viewer));
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new SearchTableLabelProvider(this, this.getControl().getDisplay()), (ILabelDecorator)new SearchLabelDecorator(), null);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setSorter((ViewerSorter)new SearchTableResultsSorter());
        this.treeMode.setEnabled(false);
        this.flatMode.setEnabled(false);
        this.compressedMode.setEnabled(false);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        this.treeContentProvider = new SearchTreeContentProvider((StructuredViewer)viewer);
        this.labelProvider = new SearchTreeLabelProvider(this, this.getControl().getDisplay());
        viewer.setContentProvider((IContentProvider)this.treeContentProvider);
        DecoratingStyledCellLabelProvider decoratedLabelProvider = new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider, (ILabelDecorator)new SearchLabelDecorator(), null);
        viewer.setLabelProvider((IBaseLabelProvider)decoratedLabelProvider);
        viewer.setSorter((ViewerSorter)new SearchTreeResultsSorter());
        this.treeMode.setEnabled(true);
        this.flatMode.setEnabled(true);
        this.compressedMode.setEnabled(true);
        if (this.treeMode.isChecked()) {
            this.treeContentProvider.setDisplayType(Folder.Type.TREE);
            this.labelProvider.setShowFileNames(true);
        } else if (this.flatMode.isChecked()) {
            this.treeContentProvider.setDisplayType(Folder.Type.FLAT);
            this.labelProvider.setShowFileNames(false);
        } else if (this.compressedMode.isChecked()) {
            this.treeContentProvider.setDisplayType(Folder.Type.COMPRESSED);
            this.labelProvider.setShowFileNames(true);
        }
    }

    protected void elementsChanged(Object[] objects) {
        this.getViewer().refresh();
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        this.openHandler.doubleClick(new DoubleClickEvent((Viewer)this.getViewer(), (ISelection)new StructuredSelection((Object)match)));
    }

    @Override
    public P4SearchResult getResult() {
        return (P4SearchResult)this.getInput();
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        tbm.appendToGroup("group.viewerSetup", (IContributionItem)new Separator(RESULTS_MODE_GROUP));
        tbm.appendToGroup(RESULTS_MODE_GROUP, this.flatMode);
        tbm.appendToGroup(RESULTS_MODE_GROUP, this.treeMode);
        tbm.appendToGroup(RESULTS_MODE_GROUP, this.compressedMode);
    }
}

