/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.results;

import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.changelists.Folder;
import com.perforce.team.ui.search.P4UiSearchPlugin;
import com.perforce.team.ui.search.query.P4SearchQuery;
import com.perforce.team.ui.search.results.FileMatch;
import com.perforce.team.ui.search.results.Messages;
import com.perforce.team.ui.search.results.RevisionMatch;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class P4SearchResult
extends AbstractTextSearchResult
implements IWorkbenchAdapter {
    private IP4Connection connection;
    private Set<IP4File> files;
    private P4SearchQuery query;
    private int trueCount = 0;
    private Folder[] folders = new Folder[0];
    private Folder[] compressed = new Folder[0];

    public P4SearchResult(P4SearchQuery query) {
        this.query = query;
        this.files = new HashSet<IP4File>();
        this.connection = (IP4Connection)P4CoreUtils.convert((Object)((Object)query), IP4Connection.class);
    }

    public void removeAll() {
        this.trueCount = 0;
        super.removeAll();
        this.folders = new Folder[0];
        this.compressed = new Folder[0];
    }

    public Object[] getChildren(Object object) {
        return this.getElements();
    }

    public String getLabel(Object object) {
        return ((P4SearchResult)((Object)object)).getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return P4UiSearchPlugin.getDescriptor("icons/depot_search.png");
    }

    public String getLabel() {
        return MessageFormat.format(Messages.P4SearchResult_TextNumMatchesInConnection, this.query.getText(), this.trueCount, this.connection.getParameters().getPort());
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public void addAll(IFileLineMatch[] matches) {
        if (matches != null) {
            Arrays.sort(matches, new Comparator<IFileLineMatch>(){

                @Override
                public int compare(IFileLineMatch o1, IFileLineMatch o2) {
                    IFileLineMatch.MatchType t1 = o1.getType();
                    IFileLineMatch.MatchType t2 = o2.getType();
                    int diff = 0;
                    if (t1 == t2) {
                        diff = o1.getLineNumber() - o2.getLineNumber();
                    } else if (IFileLineMatch.MatchType.MATCH == t1) {
                        diff = -1;
                    } else if (IFileLineMatch.MatchType.MATCH == t2) {
                        diff = 1;
                    }
                    return diff;
                }
            });
            IFileLineMatch[] iFileLineMatchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                IFileLineMatch match = iFileLineMatchArray[n2];
                this.add(match);
                ++n2;
            }
            Object[] files = this.getFiles();
            this.folders = new Folder.FolderBuilder(files, Folder.Type.TREE).build(false);
            this.compressed = new Folder.FolderBuilder(files, Folder.Type.COMPRESSED).build(true);
        }
    }

    private void add(IFileLineMatch match) {
        IP4File file;
        if (match != null && (file = this.connection.getFile(match.getDepotFile())) != null) {
            this.files.add(file);
            RevisionMatch revision = new RevisionMatch(file, match.getRevision());
            if (IFileLineMatch.MatchType.MATCH == match.getType()) {
                ++this.trueCount;
            }
            this.addMatch(new FileMatch(this.connection, revision, match));
        }
    }

    public RevisionMatch[] getRevisions(IP4File file) {
        ArrayList<RevisionMatch> revs = new ArrayList<RevisionMatch>();
        if (file != null) {
            Object[] objectArray = this.getElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (file.equals(((RevisionMatch)element).getFile())) {
                    revs.add((RevisionMatch)element);
                }
                ++n2;
            }
        }
        return revs.toArray(new RevisionMatch[revs.size()]);
    }

    public IP4File[] getFiles() {
        return this.files.toArray(new IP4File[this.files.size()]);
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return null;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.getImageDescriptor();
    }

    public Object getParent(Object o) {
        return null;
    }

    public Folder[] getFolders() {
        return this.folders;
    }

    public Folder[] getCompressed() {
        return this.compressed;
    }
}

