/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse.form;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.text.timelapse.form.FormField;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IStorageEditorInput;

public class Form {
    private SortedSet<FormField> fields;
    private IP4Connection connection = null;
    private String author = null;

    public Form(IP4Connection connection) {
        this.connection = connection;
        this.fields = new TreeSet<FormField>(new Comparator<FormField>(){

            @Override
            public int compare(FormField o1, FormField o2) {
                return o1.getOffset() - o2.getOffset();
            }
        });
    }

    public String getAuthor() {
        return this.author;
    }

    public FormField getFirst() {
        return this.fields.first();
    }

    public FormField[] getFields() {
        return this.fields.toArray(new FormField[this.fields.size()]);
    }

    public void build(Object input) {
        try {
            if (input instanceof IStorageEditorInput) {
                this.parseStream(((IStorageEditorInput)input).getStorage().getContents());
            } else if (input instanceof IStorage) {
                this.parseStream(((IStorage)input).getContents());
            } else if (input instanceof IDocument) {
                this.parseStream(new ByteArrayInputStream(((IDocument)input).get().getBytes(CharsetDefs.DEFAULT)));
            } else if (input instanceof String) {
                this.parseStream(new ByteArrayInputStream(((String)input).getBytes(CharsetDefs.DEFAULT)));
            }
        }
        catch (CoreException coreException) {
            this.fields.clear();
        }
        catch (IOException iOException) {
            this.fields.clear();
        }
    }

    private void addField(String name, StringBuilder value, int offset, int length, FormField.Type type, IJobSpec.IJobSpecField ownerField) {
        if (name != null && value != null && offset >= 0 && length > 0) {
            FormField field = new FormField(name, value.toString(), offset, length, type);
            if (!this.fields.contains(field)) {
                this.fields.add(field);
            }
            if (this.author == null && ownerField != null && name.equals(ownerField.getName())) {
                this.author = value.toString();
            }
        }
    }

    private String readLine(BufferedReader reader) throws IOException {
        int read = reader.read();
        if (read == -1) {
            return null;
        }
        StringBuilder line = new StringBuilder();
        while (read != -1) {
            line.append((char)read);
            if (read == 13) {
                reader.mark(1);
                int ahead = reader.read();
                if (ahead == 10) {
                    line.append((char)read);
                    break;
                }
                reader.reset();
                break;
            }
            if (read == 10) break;
            read = reader.read();
        }
        return line.toString();
    }

    private void parseStream(InputStream stream) throws IOException {
        try {
            IJobSpec jobSpec;
            HashMap<String, FormField.Type> typeMap = new HashMap<String, FormField.Type>();
            IJobSpec.IJobSpecField ownerField = null;
            if (this.connection != null && (jobSpec = this.connection.getJobSpec()) != null) {
                for (IJobSpec.IJobSpecField field : jobSpec.getFields()) {
                    if ("date".equals(field.getDataType())) {
                        typeMap.put(field.getName(), FormField.Type.DATE);
                    } else if ("text".equals(field.getDataType())) {
                        typeMap.put(field.getName(), FormField.Type.TEXT);
                    } else if ("select".equals(field.getDataType())) {
                        typeMap.put(field.getName(), FormField.Type.SELECT);
                    } else if ("word".equals(field.getDataType())) {
                        typeMap.put(field.getName(), FormField.Type.WORD);
                    }
                    if (ownerField != null || !"always".equals(field.getFieldType()) || !"$user".equals(jobSpec.getPresets().get(field.getName()))) continue;
                    ownerField = field;
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, ConnectionParameters.getJavaCharset((IP4Resource)this.connection)));
            String line = this.readLine(reader);
            String name = null;
            StringBuilder value = null;
            int offset = 0;
            int length = 0;
            int read = 0;
            while (line != null) {
                if (line.length() > 0) {
                    char first = line.charAt(0);
                    if (first != '#') {
                        int firstColon;
                        if (first == '\t') {
                            if (name != null) {
                                if (value == null) {
                                    value = new StringBuilder(line);
                                } else {
                                    value.append(line);
                                }
                            }
                        } else if (!Character.isWhitespace(first) && (firstColon = line.indexOf(58)) > 0) {
                            length = read - offset;
                            this.addField(name, value, offset, length, (FormField.Type)((Object)typeMap.get(name)), ownerField);
                            offset = read;
                            name = line.substring(0, firstColon);
                            if (firstColon + 1 < line.length()) {
                                String valueStart = line.substring(firstColon + 1);
                                value = new StringBuilder(valueStart.trim());
                            } else {
                                value = new StringBuilder();
                            }
                        }
                    }
                } else {
                    length = read - offset;
                    this.addField(name, value, offset, length, (FormField.Type)((Object)typeMap.get(name)), ownerField);
                }
                read += line.length();
                line = this.readLine(reader);
            }
            length = read - offset;
            this.addField(name, value, offset, length, (FormField.Type)((Object)typeMap.get(name)), ownerField);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

